/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContentType {
    private final StandardType stype;
    private final String xtype;
    private final String subtype;
    private final List<Parameter> parameters;
    private static final char QUOTE = '\"';
    private static final char BS = '\\';
    private static final String TSPECIAL = "()<>@,;:\\\"/[]?=";
    private static final String TC = "[\\p{ASCII}&&[^\\p{Cntrl}" + Pattern.quote("()<>@,;:\\\"/[]?=") + "]]";
    private static final Pattern TOKEN = Pattern.compile(TC + "+");

    public ContentType(String type, String subtype) {
        this(type, subtype, null);
    }

    public ContentType(String type, String subtype, List<Parameter> param) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (subtype == null) {
            throw new NullPointerException("type");
        }
        if ((type = ContentType.lc(type)).startsWith("x-")) {
            ContentType.checkToken(type);
            this.xtype = type;
            this.stype = null;
        } else {
            this.stype = StandardType.valueOf(type);
            this.xtype = null;
        }
        ContentType.checkToken(subtype);
        this.subtype = subtype;
        this.parameters = param != null ? new ArrayList<Parameter>(param) : Collections.emptyList();
    }

    public static ContentType parse(String string) {
        int slash = string.indexOf(47);
        if (slash == -1) {
            throw new IllegalArgumentException("No / found: " + string);
        }
        String type = string.substring(0, slash);
        String subtype = null;
        int semi = string.indexOf(59);
        if (semi == -1) {
            subtype = string.substring(slash + 1).trim();
            return new ContentType(type, subtype);
        }
        ArrayList<Parameter> p = new ArrayList<Parameter>();
        ParseState state = new ParseState();
        state.at = semi;
        while (state.at < string.length()) {
            int eq;
            if (subtype == null) {
                subtype = string.substring(slash + 1, state.at).trim();
            }
            if ((eq = string.indexOf(61, state.at)) == -1) {
                throw new IllegalArgumentException("Expected = in: " + string + " at " + state.at);
            }
            String name = string.substring(state.at + 1, eq).trim();
            state.at = eq + 1;
            String value = ContentType.value(string, state);
            p.add(new Parameter(name, value));
        }
        return new ContentType(type, subtype, p);
    }

    private static String value(String string, ParseState state) {
        boolean quoted = false;
        boolean bs = false;
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        while (state.at < string.length()) {
            char c;
            if ((c = string.charAt(state.at++)) == '\\' && quoted) {
                bs = true;
                continue;
            }
            if (c == '\"') {
                if (bs) {
                    bs = false;
                    sb.append('\"');
                    continue;
                }
                if (first) {
                    quoted = true;
                    continue;
                }
                return sb.toString();
            }
            if (c == ';' && !quoted) {
                return sb.toString();
            }
            sb.append(c);
            bs = false;
            first = false;
        }
        return sb.toString();
    }

    public static void checkToken(String t) {
        Matcher matcher = TOKEN.matcher(t);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid token: '" + t + "'");
        }
    }

    public String getType() {
        if (this.stype != null) {
            return this.stype.name();
        }
        return this.xtype;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Parameter getParameter(String attribute) {
        attribute = ContentType.lc(attribute);
        for (Parameter p : this.parameters) {
            if (!p.getAttribute().equals(attribute)) continue;
            return p;
        }
        return null;
    }

    public String getParameterValue(String attribute) {
        Parameter parameter = this.getParameter(attribute);
        if (parameter == null) {
            return null;
        }
        return parameter.getValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getType());
        sb.append('/').append(this.subtype);
        for (Parameter p : this.parameters) {
            sb.append(';').append(p);
        }
        return sb.toString();
    }

    private static String lc(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static final class Parameter {
        private String attribute;
        private String value;
        private String quoteValue;

        public Parameter(String attribute, String value) {
            if (attribute == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            ContentType.checkToken(attribute);
            this.attribute = attribute;
            this.value = value;
        }

        private void quoteValue() {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            boolean quote = false;
            for (int i = 0; i < this.value.length(); ++i) {
                char c = this.value.charAt(i);
                if (c > '\u007f') {
                    throw new IllegalArgumentException("Not ASCII " + this.value);
                }
                if (c == '\"') {
                    quote = true;
                    sb.append('\\');
                } else if (c == '\r' || c == ' ' || c == '\t') {
                    quote = true;
                } else if (ContentType.TSPECIAL.indexOf(c) != -1) {
                    quote = true;
                }
                sb.append(c);
            }
            this.quoteValue = quote ? sb.append('\"').toString() : this.value;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getValue() {
            return this.value;
        }

        public String getQuoteValue() {
            if (this.quoteValue == null) {
                this.quoteValue();
            }
            return this.quoteValue;
        }

        public String toString() {
            return this.getAttribute() + "=" + this.getQuoteValue();
        }
    }

    private static class ParseState {
        int at;

        private ParseState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StandardType {
        application,
        audio,
        image,
        message,
        multipart,
        text,
        video;

    }
}

