/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends OutputStream {
    private final OutputStream stream;
    private int remaining;

    public LimitedOutputStream(OutputStream stream, int lengthLimit) {
        if (stream == null) {
            throw new IllegalArgumentException("OutputStream parameter is null");
        }
        this.stream = stream;
        this.remaining = lengthLimit;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.remaining == 0) {
            return;
        }
        if (len > this.remaining) {
            len = this.remaining;
        }
        this.stream.write(b, off, len);
        this.remaining -= len;
    }

    public void write(int b) throws IOException {
        if (this.remaining == 0) {
            return;
        }
        this.stream.write(b);
        --this.remaining;
    }

    public String toString() {
        return "LimitedOutputStream  stream=" + this.stream + " remaining=" + this.remaining;
    }
}

