/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.net.URL;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.client.HttpClientPool;
import net.oauth.client.HttpMethodResponse;
import net.oauth.client.OAuthClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class OAuthHttpClient
extends OAuthClient {
    private final HttpClientPool clientPool;

    public OAuthHttpClient(HttpClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public OAuthMessage invoke(OAuthMessage request) throws Exception {
        GetMethod method;
        if ("GET".equals(request.method)) {
            String url = OAuth.addParameters(request.URL, request.getParameters());
            method = new GetMethod(url);
            method.setFollowRedirects(false);
        } else {
            String form = OAuth.formEncode(request.getParameters());
            PostMethod post = new PostMethod(request.URL);
            post.setRequestEntity((RequestEntity)new StringRequestEntity(form, "application/x-www-form-urlencoded", null));
            method = post;
        }
        this.clientPool.getHttpClient(new URL(method.getURI().toString())).executeMethod((HttpMethod)method);
        HttpMethodResponse response = new HttpMethodResponse((HttpMethod)method);
        int statusCode = method.getStatusCode();
        if (statusCode != 200) {
            Map<String, Object> dump = response.getDump();
            OAuthProblemException problem = new OAuthProblemException((String)dump.get("oauth_problem"));
            problem.getParameters().putAll(dump);
            throw problem;
        }
        return response;
    }
}

