/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthProblemException
extends Exception {
    public static final String OAUTH_PROBLEM = "oauth_problem";
    public static final String HTTP_STATUS_CODE = "HTTP status";
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private static final long serialVersionUID = 1L;

    public OAuthProblemException() {
    }

    public OAuthProblemException(String problem) {
        super(problem);
        if (problem != null) {
            this.parameters.put(OAUTH_PROBLEM, problem);
        }
    }

    public void setParameter(String name, Object value) {
        this.getParameters().put(name, value);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getProblem() {
        return (String)this.getParameters().get(OAUTH_PROBLEM);
    }

    public int getHttpStatusCode() {
        Object code = this.getParameters().get(HTTP_STATUS_CODE);
        if (code == null) {
            return 200;
        }
        return Integer.parseInt(code.toString());
    }
}

