/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import net.oauth.OAuthMessage;
import net.oauth.client.OAuthResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class URLConnectionResponse
extends OAuthResponseMessage {
    private final URLConnection connection;
    private String bodyAsString = null;

    public URLConnectionResponse(OAuthMessage request, URLConnection connection) throws IOException {
        super(request.method, request.URL);
        this.connection = connection;
        for (String header : connection.getHeaderFields().get("WWW-Authenticate")) {
            this.decodeWWWAuthenticate(header);
        }
    }

    @Override
    public InputStream getBodyAsStream() throws IOException {
        if (this.bodyAsString == null) {
            return this.connection.getInputStream();
        }
        return super.getBodyAsStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBodyAsString() throws IOException {
        if (this.bodyAsString == null) {
            InputStream input = this.getBodyAsStream();
            try {
                int len;
                String encoding = this.connection.getContentEncoding();
                if (encoding == null) {
                    encoding = "ISO-8859-1";
                }
                InputStreamReader reader = new InputStreamReader(input, encoding);
                StringBuilder b = new StringBuilder();
                char[] c = new char[1024];
                while (0 < (len = reader.read(c))) {
                    b.append(c, 0, len);
                }
                this.bodyAsString = b.toString();
            }
            finally {
                input.close();
            }
        }
        return this.bodyAsString;
    }

    @Override
    protected void dump(Map<String, Object> into) throws IOException {
        super.dump(into);
        StringBuilder request = new StringBuilder(this.method);
        URL url = new URL(this.URL);
        request.append(" ").append(url.getPath());
        String query = url.getQuery();
        if (query != null && query.length() > 0) {
            request.append("?").append(query);
        }
        request.append("\n");
        for (Map.Entry<String, List<String>> header : this.connection.getRequestProperties().entrySet()) {
            String key = header.getKey();
            for (String value : header.getValue()) {
                request.append(key).append(": ").append(value).append("\n");
            }
        }
        into.put("HTTP request headers", request.toString());
        StringBuilder response = new StringBuilder();
        if (this.connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)this.connection;
            response.append(http.getResponseCode());
            String message = http.getResponseMessage();
            if (message != null) {
                response.append(" ").append(message);
            }
        }
        response.append("\n");
        for (Map.Entry<String, List<String>> header : this.connection.getHeaderFields().entrySet()) {
            String key = header.getKey();
            for (String value : header.getValue()) {
                response.append(key).append(": ").append(value).append("\n");
            }
        }
        String body = this.getBodyAsString();
        if (body != null) {
            response.append("\n");
            response.append(body);
        }
        into.put("HTTP response", response.toString());
    }
}

