/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthServlet {
    private static final Integer SC_FORBIDDEN = new Integer(403);
    private static final Map<String, Integer> PROBLEM_TO_HTTP_CODE = new HashMap<String, Integer>();

    public static OAuthMessage getMessage(HttpServletRequest request, String URL) {
        if (URL == null) {
            URL = request.getRequestURL().toString();
        }
        return new OAuthMessage(request.getMethod(), URL, OAuthServlet.getParameters(request));
    }

    public static List<OAuth.Parameter> getParameters(HttpServletRequest request) {
        ArrayList<OAuth.Parameter> list = new ArrayList<OAuth.Parameter>();
        Enumeration headers = request.getHeaders("Authorization");
        while (headers != null && headers.hasMoreElements()) {
            String header = headers.nextElement().toString();
            for (OAuth.Parameter parameter : OAuthMessage.decodeAuthorization(header)) {
                if (parameter.getKey().equalsIgnoreCase("realm")) continue;
                list.add(parameter);
            }
        }
        Iterator i$ = request.getParameterMap().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = i$.next();
            String name = entry.getKey().toString();
            for (String value : (String[])entry.getValue()) {
                list.add(new OAuth.Parameter(name, value));
            }
        }
        return list;
    }

    public static String getRequestURL(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            url.append("?").append(queryString);
        }
        return url.toString();
    }

    public static void handleException(HttpServletResponse response, Exception e, String realm) throws IOException, ServletException {
        OAuthServlet.handleException(response, e, realm, true);
    }

    public static void handleException(HttpServletResponse response, Exception e, String realm, boolean sendBody) throws IOException, ServletException {
        if (e instanceof OAuthProblemException) {
            OAuthProblemException problem = (OAuthProblemException)e;
            Object httpCode = problem.getParameters().get("HTTP status");
            if (httpCode == null) {
                httpCode = PROBLEM_TO_HTTP_CODE.get(problem.getProblem());
            }
            if (httpCode == null) {
                httpCode = SC_FORBIDDEN;
            }
            response.reset();
            response.setStatus(Integer.parseInt(httpCode.toString()));
            OAuthMessage message = new OAuthMessage(null, null, problem.getParameters().entrySet());
            response.addHeader("WWW-Authenticate", message.getAuthorizationHeader(realm));
            if (sendBody) {
                OAuthServlet.sendForm(response, message.getParameters());
            }
        } else {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException((Throwable)e);
        }
    }

    public static void sendForm(HttpServletResponse response, Iterable<? extends Map.Entry> parameters) throws IOException {
        response.resetBuffer();
        response.setContentType("application/x-www-form-urlencoded;charset=UTF-8");
        OAuth.formEncode(parameters, (OutputStream)response.getOutputStream());
    }

    public static String htmlEncode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder html = new StringBuilder(s.length());
        block6: for (char c : s.toCharArray()) {
            switch (c) {
                case '<': {
                    html.append("&lt;");
                    continue block6;
                }
                case '>': {
                    html.append("&gt;");
                    continue block6;
                }
                case '&': {
                    html.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    html.append("&quot;");
                    continue block6;
                }
                default: {
                    html.append(c);
                }
            }
        }
        return html.toString();
    }

    static {
        Integer SC_BAD_REQUEST = new Integer(400);
        Integer SC_SERVICE_UNAVAILABLE = new Integer(503);
        Integer SC_UNAUTHORIZED = new Integer(401);
        PROBLEM_TO_HTTP_CODE.put("version_rejected", SC_BAD_REQUEST);
        PROBLEM_TO_HTTP_CODE.put("parameter_absent", SC_BAD_REQUEST);
        PROBLEM_TO_HTTP_CODE.put("parameter_rejected", SC_BAD_REQUEST);
        PROBLEM_TO_HTTP_CODE.put("timestamp_refused", SC_BAD_REQUEST);
        PROBLEM_TO_HTTP_CODE.put("signature_method_rejected", SC_BAD_REQUEST);
        PROBLEM_TO_HTTP_CODE.put("consumer_key_refused", SC_SERVICE_UNAVAILABLE);
        PROBLEM_TO_HTTP_CODE.put("invalid_consumer_key", SC_UNAUTHORIZED);
        PROBLEM_TO_HTTP_CODE.put("invalid_expired_token", SC_UNAUTHORIZED);
        PROBLEM_TO_HTTP_CODE.put("signature_invalid", SC_UNAUTHORIZED);
        PROBLEM_TO_HTTP_CODE.put("invalid_used_nonce", SC_UNAUTHORIZED);
        PROBLEM_TO_HTTP_CODE.put("token_not_authorized", SC_UNAUTHORIZED);
    }
}

