/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signature;

import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.oauth.OAuthAccessor;
import net.oauth.signature.OAuthSignatureMethod;

public class RSA_SHA1
extends OAuthSignatureMethod {
    public static final String PRIVATE_KEY = "RSA-SHA1.PrivateKey";
    public static final String PUBLIC_KEY = "RSA-SHA1.PublicKey";
    public static final String X509_CERTIFICATE = "RSA-SHA1.X509Certificate";
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initialize(String name, OAuthAccessor accessor) throws Exception {
        Object publicKeyObject;
        super.initialize(name, accessor);
        Object privateKeyObject = accessor.consumer.getProperty(PRIVATE_KEY);
        if (privateKeyObject != null) {
            if (privateKeyObject instanceof PrivateKey) {
                this.privateKey = (PrivateKey)privateKeyObject;
            } else if (privateKeyObject instanceof String) {
                this.privateKey = this.getPrivateKeyFromPem((String)privateKeyObject);
            } else {
                if (!(privateKeyObject instanceof byte[])) throw new IllegalArgumentException("Private key set through RSA_SHA1.PRIVATE_KEY must be of type PrivateKey, String, or byte[], and not " + privateKeyObject.getClass().getName());
                this.privateKey = this.getPrivateKeyFromDer((byte[])privateKeyObject);
            }
        }
        if ((publicKeyObject = accessor.consumer.getProperty(PUBLIC_KEY)) != null) {
            if (publicKeyObject instanceof PublicKey) {
                this.publicKey = (PublicKey)publicKeyObject;
                return;
            } else if (publicKeyObject instanceof String) {
                this.publicKey = this.getPublicKeyFromPem((String)publicKeyObject);
                return;
            } else {
                if (!(publicKeyObject instanceof byte[])) throw new IllegalArgumentException("Public key set through RSA_SHA1.PRIVATE_KEY must be of type PublicKey, String, or byte[], and not " + publicKeyObject.getClass().getName());
                this.publicKey = this.getPublicKeyFromDer((byte[])publicKeyObject);
            }
            return;
        } else {
            Object certObject = accessor.consumer.getProperty(X509_CERTIFICATE);
            if (certObject == null) return;
            if (certObject instanceof X509Certificate) {
                this.publicKey = ((X509Certificate)certObject).getPublicKey();
                return;
            } else if (certObject instanceof String) {
                this.publicKey = this.getPublicKeyFromPemCert((String)certObject);
                return;
            } else {
                if (!(certObject instanceof byte[])) throw new IllegalArgumentException("X509Certificate set through RSA_SHA1.X509_CERTIFICATE must be of type X509Certificate, String, or byte[], and not " + certObject.getClass().getName());
                this.publicKey = this.getPublicKeyFromDerCert((byte[])certObject);
            }
        }
    }

    private PublicKey getPublicKeyFromPemCert(String certObject) throws GeneralSecurityException {
        CertificateFactory fac = CertificateFactory.getInstance("X509");
        ByteArrayInputStream in = new ByteArrayInputStream(certObject.getBytes());
        X509Certificate cert = (X509Certificate)fac.generateCertificate(in);
        return cert.getPublicKey();
    }

    private PublicKey getPublicKeyFromDerCert(byte[] certObject) throws GeneralSecurityException {
        CertificateFactory fac = CertificateFactory.getInstance("X509");
        ByteArrayInputStream in = new ByteArrayInputStream(certObject);
        X509Certificate cert = (X509Certificate)fac.generateCertificate(in);
        return cert.getPublicKey();
    }

    private PublicKey getPublicKeyFromDer(byte[] publicKeyObject) throws GeneralSecurityException {
        KeyFactory fac = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKeyObject);
        return fac.generatePublic(pubKeySpec);
    }

    private PublicKey getPublicKeyFromPem(String publicKeyObject) throws GeneralSecurityException {
        return this.getPublicKeyFromDer(RSA_SHA1.decodeBase64(publicKeyObject));
    }

    private PrivateKey getPrivateKeyFromDer(byte[] privateKeyObject) throws GeneralSecurityException {
        KeyFactory fac = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privateKeyObject);
        return fac.generatePrivate(privKeySpec);
    }

    private PrivateKey getPrivateKeyFromPem(String privateKeyObject) throws GeneralSecurityException {
        return this.getPrivateKeyFromDer(RSA_SHA1.decodeBase64(privateKeyObject));
    }

    protected String getSignature(String baseString) throws Exception {
        byte[] signature = this.sign(baseString.getBytes("UTF-8"));
        return RSA_SHA1.base64Encode(signature);
    }

    protected boolean isValid(String signature, String baseString) throws Exception {
        return this.verify(RSA_SHA1.decodeBase64(signature), baseString.getBytes("UTF-8"));
    }

    private byte[] sign(byte[] message) throws GeneralSecurityException {
        if (this.privateKey == null) {
            throw new IllegalStateException("need to set private key with OAuthConsumer.setProperty when generating RSA-SHA1 signatures.");
        }
        Signature signer = Signature.getInstance("SHA1withRSA");
        signer.initSign(this.privateKey);
        signer.update(message);
        return signer.sign();
    }

    private boolean verify(byte[] signature, byte[] message) throws GeneralSecurityException {
        if (this.publicKey == null) {
            throw new IllegalStateException("need to set public key with  OAuthConsumer.setProperty when verifying RSA-SHA1 signatures.");
        }
        Signature verifier = Signature.getInstance("SHA1withRSA");
        verifier.initVerify(this.publicKey);
        verifier.update(message);
        return verifier.verify(signature);
    }
}

