/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient3;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import net.oauth.client.ExcerptInputStream;
import net.oauth.client.httpclient3.HttpClientPool;
import net.oauth.client.httpclient3.HttpMethodResponse;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class HttpClient3
implements net.oauth.http.HttpClient {
    private final HttpClientPool clientPool;
    private static final HttpClientPool SHARED_CLIENT = new SingleClient();

    public HttpClient3() {
        this(SHARED_CLIENT);
    }

    public HttpClient3(HttpClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public HttpResponseMessage execute(HttpMessage request) throws IOException {
        Object httpMethod;
        String method = request.method;
        String url = request.url.toExternalForm();
        InputStream body = request.getBody();
        boolean isDelete = "DELETE".equalsIgnoreCase(method);
        boolean isPost = "POST".equalsIgnoreCase(method);
        boolean isPut = "PUT".equalsIgnoreCase(method);
        byte[] excerpt = null;
        if (isPost || isPut) {
            PostMethod entityEnclosingMethod;
            Object object = entityEnclosingMethod = isPost ? new PostMethod(url) : new PutMethod(url);
            if (body != null) {
                ExcerptInputStream e = new ExcerptInputStream(body);
                String length = request.removeHeaders("Content-Length");
                entityEnclosingMethod.setRequestEntity((RequestEntity)(length == null ? new InputStreamRequestEntity((InputStream)e) : new InputStreamRequestEntity((InputStream)e, Long.parseLong(length))));
                excerpt = e.getExcerpt();
            }
            httpMethod = entityEnclosingMethod;
        } else {
            httpMethod = isDelete ? new DeleteMethod(url) : new GetMethod(url);
        }
        httpMethod.setFollowRedirects(false);
        for (Map.Entry<String, String> header : request.headers) {
            httpMethod.addRequestHeader(header.getKey(), header.getValue());
        }
        HttpClient client = this.clientPool.getHttpClient(new URL(httpMethod.getURI().toString()));
        client.executeMethod((HttpMethod)httpMethod);
        return new HttpMethodResponse((HttpMethod)httpMethod, excerpt, request.getContentCharset());
    }

    private static class SingleClient
    implements HttpClientPool {
        private final HttpClient client = new HttpClient();

        SingleClient() {
            this.client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        }

        public HttpClient getHttpClient(URL server) {
            return this.client;
        }
    }
}

