/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.lang.model.constraints.NotNull;
import sun.nio.ch.DirectBuffer;

public class ChronicleTcp {
    public static final long BUSY_WAIT_TIME_NS = 100000L;
    public static final int HEADER_SIZE = 12;
    public static final int INITIAL_BUFFER_SIZE = 65536;
    public static final int IN_SYNC_LEN = -128;
    public static final int PADDED_LEN = -127;
    public static final int SYNC_IDX_LEN = -126;
    public static final int ACK_LEN = -129;
    public static final int NACK_LEN = -130;
    public static final long ACTION_SUBSCRIBE = 1L;
    public static final long ACTION_UNSUBSCRIBE = 2L;
    public static final long ACTION_QUERY = 10L;
    public static final long ACTION_SUBMIT = 20L;
    public static final long ACTION_SUBMIT_NOACK = 21L;
    public static final long ACTION_WITH_MAPPING = 30L;
    public static final long IDX_NONE = 0L;
    public static final long IDX_TO_START = -1L;
    public static final long IDX_TO_END = -2L;
    public static final long IDX_ACK = -3L;
    public static final long IDX_NOT_SUPPORTED = -4L;

    public static ByteBuffer createBufferOfSize(int size) {
        return ChronicleTcp.createBufferOfSize(size, ByteOrder.nativeOrder());
    }

    public static ByteBuffer createBufferOfSize(int size, ByteOrder byteOrder) {
        return ByteBuffer.allocateDirect(size).order(byteOrder);
    }

    public static ByteBuffer createBuffer(int minSize) {
        return ChronicleTcp.createBuffer(minSize, ByteOrder.nativeOrder());
    }

    public static ByteBuffer createBuffer(int minSize, ByteOrder byteOrder) {
        int newSize = (minSize + 65536 - 1) / 65536 * 65536;
        return ChronicleTcp.createBufferOfSize(newSize, byteOrder);
    }

    public static String connectionName(String name, InetSocketAddress bindAddress, InetSocketAddress connectAddress) {
        StringBuilder sb = new StringBuilder(name);
        if (bindAddress != null && connectAddress != null) {
            sb.append("[");
            sb.append(bindAddress);
            sb.append(" -> ");
            sb.append(connectAddress);
            sb.append("]");
        } else if (bindAddress != null) {
            sb.append("[");
            sb.append(bindAddress);
            sb.append("]");
        } else if (connectAddress != null) {
            sb.append("[");
            sb.append(connectAddress);
            sb.append("]");
        }
        return sb.toString();
    }

    public static long address(@NotNull ByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static boolean hasCapacityOf(ByteBuffer buffer, int size) {
        return buffer != null ? buffer.capacity() >= size : false;
    }
}

