/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.tools.ChronicleTools;

public final class ChronicleWarmup {

    public static final class Indexed {
        public static final boolean DONE;
        private static final int WARMUP_ITER = 200000;
        private static final String TMP;

        static {
            TMP = System.getProperty("java.io.tmpdir");
            String basePath = TMP + "/warmup-" + Math.random();
            ChronicleTools.deleteOnExit(basePath);
            try {
                Chronicle ic = ChronicleQueueBuilder.indexed(basePath).dataBlockSize(64).indexBlockSize(64).build();
                ExcerptAppender appender = ic.createAppender();
                ExcerptTailer tailer = ic.createTailer();
                for (int i = 0; i < 200000; ++i) {
                    appender.startExcerpt();
                    appender.writeInt(i);
                    appender.finish();
                    boolean b = tailer.nextIndex() || tailer.nextIndex();
                    tailer.readInt();
                    tailer.finish();
                }
                ic.close();
                System.gc();
                DONE = true;
            }
            catch (IOException e) {
                throw new AssertionError();
            }
        }
    }
}

