/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.nio.ByteBuffer;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.tcp.ChronicleTcp;
import net.openhft.chronicle.tools.WrappedExcerptAppender;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.model.constraints.NotNull;

public class WrappedExcerptAppenders {

    public static class ByteBufferBytesExcerptAppenderWrapper
    extends WrappedExcerptAppender<ByteBufferBytesAppender> {
        private final int defaulCapacity;

        public ByteBufferBytesExcerptAppenderWrapper(int defaulCapacity) {
            super(ByteBufferBytesAppender.withSize(defaulCapacity));
            this.defaulCapacity = defaulCapacity;
        }

        @Override
        public void startExcerpt() {
            this.startExcerpt(this.defaulCapacity);
        }

        @Override
        public void startExcerpt(long capacity) {
            if (capacity > Integer.MAX_VALUE) {
                throw new IllegalStateException("Only capacities up to Integer.MAX_VALUE are supported");
            }
            if (capacity > (long)((ByteBufferBytesAppender)this.wrapped).buffer().capacity()) {
                this.wrapped = ByteBufferBytesAppender.withSize((int)capacity);
            }
            super.startExcerpt(capacity);
        }
    }

    public static class ByteBufferBytesAppender
    extends ByteBufferBytes
    implements ExcerptAppender {
        public ByteBufferBytesAppender(@NotNull ByteBuffer buffer) {
            super(buffer);
            this.finished = true;
        }

        @Override
        public void startExcerpt() {
            this.clear();
            this.buffer().clear();
        }

        @Override
        public void startExcerpt(long capacity) {
            if (capacity > this.capacity()) {
                throw new IllegalStateException("Excerpt's size can't exceed Excerpt's capacity");
            }
            this.clear();
            this.buffer().clear();
            this.limit(capacity);
            this.buffer().limit((int)capacity);
        }

        @Override
        public boolean wasPadding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long lastWrittenIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Chronicle chronicle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPaddedEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean nextSynchronous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void nextSynchronous(boolean nextSynchronous) {
            throw new UnsupportedOperationException();
        }

        public static ByteBufferBytesAppender withSize(int size) {
            return new ByteBufferBytesAppender(ChronicleTcp.createBufferOfSize(size));
        }
    }
}

