/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashByteDoubleMap}s.
 *
 * @see HashByteDoubleMap
 * @see HashByteDoubleMaps#getDefaultFactory()
 */
public interface HashByteDoubleMapFactory
        extends ByteDoubleMapFactory<HashByteDoubleMapFactory>
        , ByteHashFactory<HashByteDoubleMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap();

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4,
            @Nonnull Map<Byte, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(
            @Nonnull Map<Byte, Double> map);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4,
            @Nonnull Map<Byte, Double> map5);



    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashByteDoubleMap newMutableMapOf(byte k1, double v1);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

    @Override
    @Nonnull
     HashByteDoubleMap newMutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);
    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap();

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4,
            @Nonnull Map<Byte, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(
            @Nonnull Map<Byte, Double> map);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4,
            @Nonnull Map<Byte, Double> map5);



    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

    @Override
    @Nonnull
     HashByteDoubleMap newUpdatableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);

    


    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4,
            @Nonnull Map<Byte, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(
            @Nonnull Map<Byte, Double> map);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Map<Byte, Double> map1,
            @Nonnull Map<Byte, Double> map2,
            @Nonnull Map<Byte, Double> map3,
            @Nonnull Map<Byte, Double> map4,
            @Nonnull Map<Byte, Double> map5);



    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4);

    @Override
    @Nonnull
     HashByteDoubleMap newImmutableMapOf(byte k1, double v1,
            byte k2, double v2, byte k3, double v3,
            byte k4, double v4, byte k5, double v5);
}

