/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashDoubleDoubleMap}s.
 *
 * @see HashDoubleDoubleMap
 * @see HashDoubleDoubleMaps#getDefaultFactory()
 */
public interface HashDoubleDoubleMapFactory
        extends DoubleDoubleMapFactory<HashDoubleDoubleMapFactory>
        , HashContainerFactory<HashDoubleDoubleMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap();

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4,
            @Nonnull Map<Double, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(
            @Nonnull double[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(
            @Nonnull Map<Double, Double> map);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4,
            @Nonnull Map<Double, Double> map5);



    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(
            @Nonnull double[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

    @Override
    @Nonnull
     HashDoubleDoubleMap newMutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);
    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap();

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4,
            @Nonnull Map<Double, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(
            @Nonnull Map<Double, Double> map);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4,
            @Nonnull Map<Double, Double> map5);



    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

    @Override
    @Nonnull
     HashDoubleDoubleMap newUpdatableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);

    


    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4,
            @Nonnull Map<Double, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(
            @Nonnull Map<Double, Double> map);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Map<Double, Double> map1,
            @Nonnull Map<Double, Double> map2,
            @Nonnull Map<Double, Double> map3,
            @Nonnull Map<Double, Double> map4,
            @Nonnull Map<Double, Double> map5);



    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.DoubleDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4);

    @Override
    @Nonnull
     HashDoubleDoubleMap newImmutableMapOf(double k1, double v1,
            double k2, double v2, double k3, double v3,
            double k4, double v4, double k5, double v5);
}

