/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashFloatDoubleMap}s.
 *
 * @see HashFloatDoubleMap
 * @see HashFloatDoubleMaps#getDefaultFactory()
 */
public interface HashFloatDoubleMapFactory
        extends FloatDoubleMapFactory<HashFloatDoubleMapFactory>
        , HashContainerFactory<HashFloatDoubleMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap();

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4,
            @Nonnull Map<Float, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(
            @Nonnull float[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(
            @Nonnull Map<Float, Double> map);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4,
            @Nonnull Map<Float, Double> map5);



    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(
            @Nonnull float[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMapOf(float k1, double v1);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

    @Override
    @Nonnull
     HashFloatDoubleMap newMutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);
    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap();

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4,
            @Nonnull Map<Float, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(
            @Nonnull Map<Float, Double> map);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4,
            @Nonnull Map<Float, Double> map5);



    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

    @Override
    @Nonnull
     HashFloatDoubleMap newUpdatableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);

    


    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4,
            @Nonnull Map<Float, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(
            @Nonnull Map<Float, Double> map);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Map<Float, Double> map1,
            @Nonnull Map<Float, Double> map2,
            @Nonnull Map<Float, Double> map3,
            @Nonnull Map<Float, Double> map4,
            @Nonnull Map<Float, Double> map5);



    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4);

    @Override
    @Nonnull
     HashFloatDoubleMap newImmutableMapOf(float k1, double v1,
            float k2, double v2, float k3, double v3,
            float k4, double v4, float k5, double v5);
}

