/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashFloatFloatMap}s.
 *
 * @see HashFloatFloatMap
 * @see HashFloatFloatMaps#getDefaultFactory()
 */
public interface HashFloatFloatMapFactory
        extends FloatFloatMapFactory<HashFloatFloatMapFactory>
        , HashContainerFactory<HashFloatFloatMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap();

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4,
            @Nonnull Map<Float, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(
            @Nonnull float[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(
            @Nonnull Map<Float, Float> map);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4,
            @Nonnull Map<Float, Float> map5);



    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(
            @Nonnull float[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashFloatFloatMap newMutableMapOf(float k1, float v1);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

    @Override
    @Nonnull
     HashFloatFloatMap newMutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);
    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap();

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4,
            @Nonnull Map<Float, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(
            @Nonnull Map<Float, Float> map);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4,
            @Nonnull Map<Float, Float> map5);



    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

    @Override
    @Nonnull
     HashFloatFloatMap newUpdatableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);

    


    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4,
            @Nonnull Map<Float, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(
            @Nonnull Map<Float, Float> map);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Map<Float, Float> map1,
            @Nonnull Map<Float, Float> map2,
            @Nonnull Map<Float, Float> map3,
            @Nonnull Map<Float, Float> map4,
            @Nonnull Map<Float, Float> map5);



    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.FloatFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMapOf(float k1, float v1);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4);

    @Override
    @Nonnull
     HashFloatFloatMap newImmutableMapOf(float k1, float v1,
            float k2, float v2, float k3, float v3,
            float k4, float v4, float k5, float v5);
}

