/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashLongIntMap}s.
 *
 * @see HashLongIntMap
 * @see HashLongIntMaps#getDefaultFactory()
 */
public interface HashLongIntMapFactory
        extends LongIntMapFactory<HashLongIntMapFactory>
        , LongHashFactory<HashLongIntMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashLongIntMap newMutableMap();

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4,
            @Nonnull Map<Long, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(
            @Nonnull long[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(
            @Nonnull Map<Long, Integer> map);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4,
            @Nonnull Map<Long, Integer> map5);



    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(
            @Nonnull long[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashLongIntMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashLongIntMap newMutableMapOf(long k1, int v1);

    @Override
    @Nonnull
     HashLongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2);

    @Override
    @Nonnull
     HashLongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

    @Override
    @Nonnull
     HashLongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

    @Override
    @Nonnull
     HashLongIntMap newMutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);
    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap();

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4,
            @Nonnull Map<Long, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(
            @Nonnull Map<Long, Integer> map);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4,
            @Nonnull Map<Long, Integer> map5);



    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashLongIntMap newUpdatableMapOf(long k1, int v1);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

    @Override
    @Nonnull
     HashLongIntMap newUpdatableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);

    


    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4,
            @Nonnull Map<Long, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(
            @Nonnull Map<Long, Integer> map);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Map<Long, Integer> map1,
            @Nonnull Map<Long, Integer> map2,
            @Nonnull Map<Long, Integer> map3,
            @Nonnull Map<Long, Integer> map4,
            @Nonnull Map<Long, Integer> map5);



    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashLongIntMap newImmutableMapOf(long k1, int v1);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4);

    @Override
    @Nonnull
     HashLongIntMap newImmutableMapOf(long k1, int v1,
            long k2, int v2, long k3, int v3,
            long k4, int v4, long k5, int v5);
}

