/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashObjByteMap}s.
 *
 * @see HashObjByteMap
 * @see HashObjByteMaps#getDefaultFactory()
 */
public interface HashObjByteMapFactory<K>
        extends ObjByteMapFactory<K, HashObjByteMapFactory<K>>
        , ObjHashFactory<HashObjByteMapFactory<K>>
        {

    /**
     * {@inheritDoc} Defaults to {@link Equivalence#defaultEquality()}.
     */
    @Override
    @Nonnull Equivalence<K> getKeyEquivalence();

    

    

    

    

    

    
    

    
    

    /**
     * Returns a copy of this factory, with exception that it constructs maps with
     * {@linkplain HashObjByteMap#keyEquivalence() key equivalence} set to the given
     * {@code Equivalence}.
     *
     * @param keyEquivalence the new key equivalence
     * @return a copy of this factory, which constructs maps with the given {@code keyEquivalence}
     */
    @Nonnull
    HashObjByteMapFactory<K>
    withKeyEquivalence(@Nonnull Equivalence<? super K> keyEquivalence);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap();

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(
            @Nonnull Map<? extends K2, Byte> map, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4,
            @Nonnull Map<? extends K2, Byte> map5, int expectedSize);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ObjByteConsumer<K2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(
            @Nonnull K2[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(
            @Nonnull K2[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(
            @Nonnull Map<? extends K2, Byte> map);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4,
            @Nonnull Map<? extends K2, Byte> map5);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ObjByteConsumer<K2>> entriesSupplier
            );

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(
            @Nonnull K2[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(
            @Nonnull K2[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMapOf(K2 k1, byte v1);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMapOf(K2 k1, byte v1,
            K2 k2, byte v2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3,
            K2 k4, byte v4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newMutableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3,
            K2 k4, byte v4, K2 k5, byte v5);
    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap();

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(
            @Nonnull Map<? extends K2, Byte> map, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4,
            @Nonnull Map<? extends K2, Byte> map5, int expectedSize);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ObjByteConsumer<K2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(
            @Nonnull K2[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(
            @Nonnull K2[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(
            @Nonnull Map<? extends K2, Byte> map);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4,
            @Nonnull Map<? extends K2, Byte> map5);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ObjByteConsumer<K2>> entriesSupplier
            );

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(
            @Nonnull K2[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(
            @Nonnull K2[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMapOf(K2 k1, byte v1);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMapOf(K2 k1, byte v1,
            K2 k2, byte v2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3,
            K2 k4, byte v4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newUpdatableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3,
            K2 k4, byte v4, K2 k5, byte v5);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(
            @Nonnull Map<? extends K2, Byte> map, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4,
            @Nonnull Map<? extends K2, Byte> map5, int expectedSize);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ObjByteConsumer<K2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(
            @Nonnull K2[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(
            @Nonnull K2[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(
            @Nonnull Map<? extends K2, Byte> map);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Byte> map1,
            @Nonnull Map<? extends K2, Byte> map2,
            @Nonnull Map<? extends K2, Byte> map3,
            @Nonnull Map<? extends K2, Byte> map4,
            @Nonnull Map<? extends K2, Byte> map5);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ObjByteConsumer<K2>> entriesSupplier
            );

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(
            @Nonnull K2[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(
            @Nonnull K2[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMapOf(K2 k1, byte v1);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMapOf(K2 k1, byte v1,
            K2 k2, byte v2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3,
            K2 k4, byte v4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjByteMap<K2> newImmutableMapOf(K2 k1, byte v1,
            K2 k2, byte v2, K2 k3, byte v3,
            K2 k4, byte v4, K2 k5, byte v5);
}

