/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashShortShortMap}s.
 *
 * @see HashShortShortMap
 * @see HashShortShortMaps#getDefaultFactory()
 */
public interface HashShortShortMapFactory
        extends ShortShortMapFactory<HashShortShortMapFactory>
        , ShortHashFactory<HashShortShortMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashShortShortMap newMutableMap();

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4,
            @Nonnull Map<Short, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(
            @Nonnull short[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(
            @Nonnull Map<Short, Short> map);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4,
            @Nonnull Map<Short, Short> map5);



    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(
            @Nonnull short[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashShortShortMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashShortShortMap newMutableMapOf(short k1, short v1);

    @Override
    @Nonnull
     HashShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2);

    @Override
    @Nonnull
     HashShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

    @Override
    @Nonnull
     HashShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

    @Override
    @Nonnull
     HashShortShortMap newMutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);
    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap();

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4,
            @Nonnull Map<Short, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(
            @Nonnull Map<Short, Short> map);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4,
            @Nonnull Map<Short, Short> map5);



    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashShortShortMap newUpdatableMapOf(short k1, short v1);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

    @Override
    @Nonnull
     HashShortShortMap newUpdatableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);

    


    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4,
            @Nonnull Map<Short, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(
            @Nonnull Map<Short, Short> map);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Map<Short, Short> map1,
            @Nonnull Map<Short, Short> map2,
            @Nonnull Map<Short, Short> map3,
            @Nonnull Map<Short, Short> map4,
            @Nonnull Map<Short, Short> map5);



    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashShortShortMap newImmutableMapOf(short k1, short v1);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4);

    @Override
    @Nonnull
     HashShortShortMap newImmutableMapOf(short k1, short v1,
            short k2, short v2, short k3, short v3,
            short k4, short v4, short k5, short v5);
}

