/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.set.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.set.ObjSetFactory;

import javax.annotation.Nonnull;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashObjSet}s.
 *
 * @see HashObjSet
 * @see HashObjSets#getDefaultFactory()
 */
public interface HashObjSetFactory<E>
        extends ObjSetFactory<E, HashObjSetFactory<E>>
        , ObjHashFactory<HashObjSetFactory<E>>
         {

    /**
     * {@inheritDoc} Defaults to {@link Equivalence#defaultEquality()}.
     */
    @Override
    @Nonnull
    Equivalence<E> getEquivalence();

    /**
     * Returns a copy of this factory, with exception that it constructs sets with
     * {@linkplain ObjCollection#equivalence() element equivalence} set to the given
     * {@code Equivalence}.
     *
     * @param equivalence the new element equivalence
     * @return a copy of this factory, which constructs sets with the given {@code keyEquivalence}
     */
    @Nonnull
    HashObjSetFactory<E> withEquivalence(
            @Nonnull Equivalence<? super E> equivalence);

    

    

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet();

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(int expectedSize);

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elements, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4,
            @Nonnull Iterable<? extends E2> elems5, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterator<? extends E2> elements, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.Consumer<E2>> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull E2[] elements, int expectedSize);


    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elements);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4,
            @Nonnull Iterable<? extends E2> elems5);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull Iterator<? extends E2> elements);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.Consumer<E2>> elementsSupplier
            );

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSet(@Nonnull E2[] elements);



    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2,
            E2 e3);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4, E2 e5,
            E2... restElements);
    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet();

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(int expectedSize);

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elements, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4,
            @Nonnull Iterable<? extends E2> elems5, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterator<? extends E2> elements, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.Consumer<E2>> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull E2[] elements, int expectedSize);


    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elements);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4,
            @Nonnull Iterable<? extends E2> elems5);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull Iterator<? extends E2> elements);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.Consumer<E2>> elementsSupplier
            );

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSet(@Nonnull E2[] elements);



    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1, E2 e2);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1, E2 e2,
            E2 e3);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newUpdatableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4, E2 e5,
            E2... restElements);

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elements, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4,
            @Nonnull Iterable<? extends E2> elems5, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterator<? extends E2> elements, int expectedSize);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.Consumer<E2>> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull E2[] elements, int expectedSize);


    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elements);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterable<? extends E2> elems1,
            @Nonnull Iterable<? extends E2> elems2,
            @Nonnull Iterable<? extends E2> elems3,
            @Nonnull Iterable<? extends E2> elems4,
            @Nonnull Iterable<? extends E2> elems5);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull Iterator<? extends E2> elements);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.Consumer<E2>> elementsSupplier
            );

    

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSet(@Nonnull E2[] elements);



    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2,
            E2 e3);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4);

    @Override
    @Nonnull
    <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2,
            E2 e3, E2 e4, E2 e5,
            E2... restElements);
}

