/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.set.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.set.ShortSetFactory;

import javax.annotation.Nonnull;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashShortSet}s.
 *
 * @see HashShortSet
 * @see HashShortSets#getDefaultFactory()
 */
public interface HashShortSetFactory
        extends ShortSetFactory<HashShortSetFactory>
        , ShortHashFactory<HashShortSetFactory>
         {



    

    

    

    @Override
    @Nonnull
     HashShortSet newMutableSet();

    @Override
    @Nonnull
     HashShortSet newMutableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4,
            @Nonnull Iterable<Short> elems5, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterator<Short> elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull short[] elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Short[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elements);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4,
            @Nonnull Iterable<Short> elems5);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Iterator<Short> elements);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull short[] elements);

    @Override
    @Nonnull
     HashShortSet newMutableSet(@Nonnull Short[] elements);


    @Override
    @Nonnull
     HashShortSet newMutableSetOf(short e1);

    @Override
    @Nonnull
     HashShortSet newMutableSetOf(short e1, short e2);

    @Override
    @Nonnull
     HashShortSet newMutableSetOf(short e1, short e2,
            short e3);

    @Override
    @Nonnull
     HashShortSet newMutableSetOf(short e1, short e2,
            short e3, short e4);

    @Override
    @Nonnull
     HashShortSet newMutableSetOf(short e1, short e2,
            short e3, short e4, short e5,
            short... restElements);
    @Override
    @Nonnull
     HashShortSet newUpdatableSet();

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4,
            @Nonnull Iterable<Short> elems5, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterator<Short> elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull short[] elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Short[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elements);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4,
            @Nonnull Iterable<Short> elems5);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Iterator<Short> elements);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull short[] elements);

    @Override
    @Nonnull
     HashShortSet newUpdatableSet(@Nonnull Short[] elements);


    @Override
    @Nonnull
     HashShortSet newUpdatableSetOf(short e1);

    @Override
    @Nonnull
     HashShortSet newUpdatableSetOf(short e1, short e2);

    @Override
    @Nonnull
     HashShortSet newUpdatableSetOf(short e1, short e2,
            short e3);

    @Override
    @Nonnull
     HashShortSet newUpdatableSetOf(short e1, short e2,
            short e3, short e4);

    @Override
    @Nonnull
     HashShortSet newUpdatableSetOf(short e1, short e2,
            short e3, short e4, short e5,
            short... restElements);

    

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4,
            @Nonnull Iterable<Short> elems5, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterator<Short> elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull short[] elements, int expectedSize);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Short[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elements);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterable<Short> elems1,
            @Nonnull Iterable<Short> elems2,
            @Nonnull Iterable<Short> elems3,
            @Nonnull Iterable<Short> elems4,
            @Nonnull Iterable<Short> elems5);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Iterator<Short> elements);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull short[] elements);

    @Override
    @Nonnull
     HashShortSet newImmutableSet(@Nonnull Short[] elements);


    @Override
    @Nonnull
     HashShortSet newImmutableSetOf(short e1);

    @Override
    @Nonnull
     HashShortSet newImmutableSetOf(short e1, short e2);

    @Override
    @Nonnull
     HashShortSet newImmutableSetOf(short e1, short e2,
            short e3);

    @Override
    @Nonnull
     HashShortSet newImmutableSetOf(short e1, short e2,
            short e3, short e4);

    @Override
    @Nonnull
     HashShortSet newImmutableSetOf(short e1, short e2,
            short e3, short e4, short e5,
            short... restElements);
}

