/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.collection;

import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;

public class SingleThreadedDirectBitSet
implements DirectBitSet {
    public static final long ALL_ONES = -1L;
    private Bytes bytes;
    private long longLength;

    static long singleBit(long bitIndex) {
        return 1L << (int)bitIndex;
    }

    static long higherBitsIncludingThis(long bitIndex) {
        return -1L << (int)bitIndex;
    }

    static long lowerBitsIncludingThis(long bitIndex) {
        return -1L >>> (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static long higherBitsExcludingThis(long bitIndex) {
        return -1L >>> (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    static long lowerBitsExcludingThis(long bitIndex) {
        return -1L << (int)bitIndex ^ 0xFFFFFFFFFFFFFFFFL;
    }

    static long longWithThisBit(long bitIndex) {
        return bitIndex >> 6;
    }

    static long firstByte(long longIndex) {
        return longIndex << 3;
    }

    static long firstBit(long longIndex) {
        return longIndex << 6;
    }

    static long lastBit(long longIndex) {
        return SingleThreadedDirectBitSet.firstBit(longIndex) + 63L;
    }

    public SingleThreadedDirectBitSet() {
    }

    public SingleThreadedDirectBitSet(Bytes bytes) {
        this.reuse(bytes);
    }

    public void reuse(Bytes bytes) {
        this.bytes = bytes;
        this.longLength = bytes.capacity() >> 3;
    }

    static void checkNumberOfBits(int numberOfBits) {
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException("Illegal number of bits: " + numberOfBits);
        }
    }

    static boolean checkNotFoundIndex(long fromIndex) {
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return true;
            }
            throw new IndexOutOfBoundsException();
        }
        return false;
    }

    private void checkIndex(long bitIndex, long longIndex) {
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFromTo(long fromIndex, long exclusiveToIndex, long toLongIndex) {
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
    }

    private long readLong(long longIndex) {
        return this.bytes.readLong(SingleThreadedDirectBitSet.firstByte(longIndex));
    }

    private void writeLong(long longIndex, long toWrite) {
        this.bytes.writeLong(SingleThreadedDirectBitSet.firstByte(longIndex), toWrite);
    }

    @Override
    public void reserve() {
        this.bytes.reserve();
    }

    @Override
    public boolean release() {
        return this.bytes.release();
    }

    @Override
    public int refCount() {
        return this.bytes.refCount();
    }

    @Override
    public DirectBitSet flip(long bitIndex) {
        long longIndex = SingleThreadedDirectBitSet.longWithThisBit(bitIndex);
        this.checkIndex(bitIndex, longIndex);
        long byteIndex = SingleThreadedDirectBitSet.firstByte(longIndex);
        long mask = SingleThreadedDirectBitSet.singleBit(bitIndex);
        long l = this.bytes.readLong(byteIndex);
        long l2 = l ^ mask;
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public DirectBitSet flip(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedDirectBitSet.longWithThisBit(toIndex);
        this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex);
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex);
                mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex);
                l = this.bytes.readLong(fromByteIndex);
                l2 = l ^ mask;
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.writeLong(i, this.readLong(i) ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.writeLong(i, this.readLong(i) ^ 0xFFFFFFFFFFFFFFFFL);
                }
                long toByteIndex = SingleThreadedDirectBitSet.firstByte(toLongIndex);
                mask = SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
                l = this.bytes.readLong(toByteIndex);
                l2 = l ^ mask;
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex);
            long mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex) & SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
            long l = this.bytes.readLong(byteIndex);
            long l2 = l ^ mask;
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    @Override
    public DirectBitSet set(long bitIndex) {
        long longIndex = SingleThreadedDirectBitSet.longWithThisBit(bitIndex);
        this.checkIndex(bitIndex, longIndex);
        long byteIndex = SingleThreadedDirectBitSet.firstByte(longIndex);
        long mask = SingleThreadedDirectBitSet.singleBit(bitIndex);
        long l = this.bytes.readLong(byteIndex);
        if ((l & mask) != 0L) {
            return this;
        }
        long l2 = l | mask;
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public boolean setIfClear(long bitIndex) {
        long longIndex = SingleThreadedDirectBitSet.longWithThisBit(bitIndex);
        this.checkIndex(bitIndex, longIndex);
        long byteIndex = SingleThreadedDirectBitSet.firstByte(longIndex);
        long mask = SingleThreadedDirectBitSet.singleBit(bitIndex);
        long l = this.bytes.readLong(byteIndex);
        long l2 = l | mask;
        if (l == l2) {
            return false;
        }
        this.bytes.writeLong(byteIndex, l2);
        return true;
    }

    @Override
    public DirectBitSet set(long bitIndex, boolean value) {
        return value ? this.set(bitIndex) : this.clear(bitIndex);
    }

    @Override
    public DirectBitSet set(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedDirectBitSet.longWithThisBit(toIndex);
        this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex);
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex);
                mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex);
                l = this.bytes.readLong(fromByteIndex);
                l2 = l | mask;
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.writeLong(i, -1L);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.writeLong(i, -1L);
                }
                long toByteIndex = SingleThreadedDirectBitSet.firstByte(toLongIndex);
                mask = SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
                l = this.bytes.readLong(toByteIndex);
                l2 = l | mask;
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex);
            long mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex) & SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
            long l = this.bytes.readLong(byteIndex);
            long l2 = l | mask;
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    @Override
    public DirectBitSet setAll() {
        for (long i = 0L; i < this.longLength; ++i) {
            this.writeLong(i, -1L);
        }
        return this;
    }

    @Override
    public DirectBitSet set(long fromIndex, long toIndex, boolean value) {
        return value ? this.set(fromIndex, toIndex) : this.clear(fromIndex, toIndex);
    }

    @Override
    public DirectBitSet clear(long bitIndex) {
        long longIndex = SingleThreadedDirectBitSet.longWithThisBit(bitIndex);
        this.checkIndex(bitIndex, longIndex);
        long byteIndex = SingleThreadedDirectBitSet.firstByte(longIndex);
        long mask = SingleThreadedDirectBitSet.singleBit(bitIndex);
        long l = this.bytes.readLong(byteIndex);
        if ((l & mask) == 0L) {
            return this;
        }
        long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.bytes.writeLong(byteIndex, l2);
        return this;
    }

    @Override
    public boolean clearIfSet(long bitIndex) {
        long longIndex = SingleThreadedDirectBitSet.longWithThisBit(bitIndex);
        this.checkIndex(bitIndex, longIndex);
        long byteIndex = SingleThreadedDirectBitSet.firstByte(longIndex);
        long mask = SingleThreadedDirectBitSet.singleBit(bitIndex);
        long l = this.bytes.readLong(byteIndex);
        if ((l & mask) == 0L) {
            return false;
        }
        long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.bytes.writeLong(byteIndex, l2);
        return true;
    }

    @Override
    public DirectBitSet clear(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedDirectBitSet.longWithThisBit(toIndex);
        this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex);
        if (fromLongIndex != toLongIndex) {
            long i;
            long l2;
            long l;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex);
                mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex);
                l = this.bytes.readLong(fromByteIndex);
                l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                this.bytes.writeLong(fromByteIndex, l2);
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    this.writeLong(i, 0L);
                }
            } else {
                for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                    this.writeLong(i, 0L);
                }
                long toByteIndex = SingleThreadedDirectBitSet.firstByte(toLongIndex);
                mask = SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
                l = this.bytes.readLong(toByteIndex);
                l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                this.bytes.writeLong(toByteIndex, l2);
            }
        } else {
            long byteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex);
            long mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex) & SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
            long l = this.bytes.readLong(byteIndex);
            long l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            this.bytes.writeLong(byteIndex, l2);
        }
        return this;
    }

    public boolean allSet(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedDirectBitSet.longWithThisBit(toIndex);
        this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex);
        if (fromLongIndex != toLongIndex) {
            long i;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex);
                if (((this.readLong(fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) & mask) != 0L) {
                    return false;
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    if ((this.readLong(i) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
                    return false;
                }
                return true;
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                if ((this.readLong(i) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
                return false;
            }
            mask = SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
            return ((this.readLong(toLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) & mask) == 0L;
        }
        long mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex) & SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
        return ((this.readLong(fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) & mask) == 0L;
    }

    public boolean allClear(long fromIndex, long exclusiveToIndex) {
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedDirectBitSet.longWithThisBit(toIndex);
        this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex);
        if (fromLongIndex != toLongIndex) {
            long i;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex);
                if ((this.readLong(fromLongIndex) & mask) != 0L) {
                    return false;
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                for (i = firstFullLongIndex; i <= toLongIndex; ++i) {
                    if (this.readLong(i) == 0L) continue;
                    return false;
                }
                return true;
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                if (this.readLong(i) == 0L) continue;
                return false;
            }
            mask = SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
            return (this.readLong(toLongIndex) & mask) == 0L;
        }
        long mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(fromIndex) & SingleThreadedDirectBitSet.lowerBitsIncludingThis(toIndex);
        return (this.readLong(fromLongIndex) & mask) == 0L;
    }

    @Override
    public DirectBitSet clear() {
        this.bytes.zeroOut();
        return this;
    }

    @Override
    public boolean get(long bitIndex) {
        long longIndex = SingleThreadedDirectBitSet.longWithThisBit(bitIndex);
        this.checkIndex(bitIndex, longIndex);
        long l = this.readLong(longIndex);
        return (l & SingleThreadedDirectBitSet.singleBit(bitIndex)) != 0L;
    }

    @Override
    public boolean isSet(long bitIndex) {
        return this.get(bitIndex);
    }

    @Override
    public boolean isClear(long bitIndex) {
        return !this.get(bitIndex);
    }

    @Override
    public long getLong(long longIndex) {
        this.checkIndex(longIndex, longIndex);
        return this.readLong(longIndex);
    }

    @Override
    public long nextSetBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = this.readLong(fromLongIndex) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.readLong(i);
            if (l == 0L) continue;
            return SingleThreadedDirectBitSet.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public DirectBitSet.Bits setBits() {
        return new SetBits();
    }

    @Override
    public long clearNextSetBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex);
        long w = this.bytes.readLong(fromByteIndex);
        long l = w >>> (int)fromIndex;
        if (l != 0L) {
            long indexOfSetBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedDirectBitSet.singleBit(indexOfSetBit);
            this.bytes.writeLong(fromByteIndex, w ^ mask);
            return indexOfSetBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long byteIndex = SingleThreadedDirectBitSet.firstByte(i);
            l = this.bytes.readLong(byteIndex);
            if (l == 0L) continue;
            long indexOfSetBit = SingleThreadedDirectBitSet.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedDirectBitSet.singleBit(indexOfSetBit);
            this.bytes.writeLong(byteIndex, l ^ mask);
            return indexOfSetBit;
        }
        return -1L;
    }

    @Override
    public long nextSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.readLong(fromLongIndex) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.readLong(i) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long nextClearBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = (this.readLong(fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.readLong(i) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return SingleThreadedDirectBitSet.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long setNextClearBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex);
        long w = this.bytes.readLong(fromByteIndex);
        long l = (w ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            long indexOfClearBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedDirectBitSet.singleBit(indexOfClearBit);
            this.bytes.writeLong(fromByteIndex, w ^ mask);
            return indexOfClearBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long byteIndex = SingleThreadedDirectBitSet.firstByte(i);
            w = this.bytes.readLong(byteIndex);
            l = w ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            long indexOfClearBit = SingleThreadedDirectBitSet.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedDirectBitSet.singleBit(indexOfClearBit);
            this.bytes.writeLong(byteIndex, w ^ mask);
            return indexOfClearBit;
        }
        return -1L;
    }

    @Override
    public long nextClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.readLong(fromLongIndex) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.readLong(i) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousSetBit(long fromIndex) {
        long l;
        if (SingleThreadedDirectBitSet.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = this.readLong(fromLongIndex) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.readLong(i);
            if (l == 0L) continue;
            return SingleThreadedDirectBitSet.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    private long previousSetBit(long fromIndex, long inclusiveToIndex) {
        long mask;
        long w;
        long l;
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        long toLongIndex = SingleThreadedDirectBitSet.longWithThisBit(inclusiveToIndex);
        this.checkFromTo(inclusiveToIndex, fromIndex + 1L, toLongIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if (fromLongIndex != toLongIndex) {
            long l2 = this.readLong(fromLongIndex) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL);
            if (l2 != 0L) {
                return fromIndex - (long)Long.numberOfLeadingZeros(l2);
            }
            for (long i = fromLongIndex - 1L; i > toLongIndex; --i) {
                l2 = this.readLong(i);
                if (l2 == 0L) continue;
                return SingleThreadedDirectBitSet.lastBit(i) - (long)Long.numberOfLeadingZeros(l2);
            }
            fromIndex = SingleThreadedDirectBitSet.lastBit(toLongIndex);
        }
        if ((l = (w = this.readLong(toLongIndex)) & (mask = SingleThreadedDirectBitSet.higherBitsIncludingThis(inclusiveToIndex) & SingleThreadedDirectBitSet.lowerBitsIncludingThis(fromIndex))) != 0L) {
            return SingleThreadedDirectBitSet.lastBit(toLongIndex) - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long clearPreviousSetBit(long fromIndex) {
        long fromByteIndex;
        long w;
        long l;
        if (SingleThreadedDirectBitSet.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = (w = this.bytes.readLong(fromByteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex))) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfSetBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedDirectBitSet.singleBit(indexOfSetBit);
            this.bytes.writeLong(fromByteIndex, w ^ mask);
            return indexOfSetBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long byteIndex = SingleThreadedDirectBitSet.firstByte(i);
            l = this.bytes.readLong(byteIndex);
            if (l == 0L) continue;
            long indexOfSetBit = SingleThreadedDirectBitSet.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedDirectBitSet.singleBit(indexOfSetBit);
            this.bytes.writeLong(byteIndex, l ^ mask);
            return indexOfSetBit;
        }
        return -1L;
    }

    @Override
    public long previousSetLong(long fromLongIndex) {
        if (SingleThreadedDirectBitSet.checkNotFoundIndex(fromLongIndex)) {
            return -1L;
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.readLong(fromLongIndex) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.readLong(i) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousClearBit(long fromIndex) {
        long l;
        if (SingleThreadedDirectBitSet.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = (this.readLong(fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.readLong(i) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return SingleThreadedDirectBitSet.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long setPreviousClearBit(long fromIndex) {
        long fromByteIndex;
        long w;
        long l;
        if (SingleThreadedDirectBitSet.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = ((w = this.bytes.readLong(fromByteIndex = SingleThreadedDirectBitSet.firstByte(fromLongIndex))) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfClearBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedDirectBitSet.singleBit(indexOfClearBit);
            this.bytes.writeLong(fromByteIndex, w ^ mask);
            return indexOfClearBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long byteIndex = SingleThreadedDirectBitSet.firstByte(i);
            w = this.bytes.readLong(byteIndex);
            l = w ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            long indexOfClearBit = SingleThreadedDirectBitSet.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedDirectBitSet.singleBit(indexOfClearBit);
            this.bytes.writeLong(byteIndex, w ^ mask);
            return indexOfClearBit;
        }
        return -1L;
    }

    @Override
    public long previousClearLong(long fromLongIndex) {
        if (SingleThreadedDirectBitSet.checkNotFoundIndex(fromLongIndex)) {
            return -1L;
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.readLong(fromLongIndex) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.readLong(i) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long size() {
        return this.longLength << 6;
    }

    @Override
    public long cardinality() {
        long count = 0L;
        for (long i = 0L; i < this.longLength; ++i) {
            count += (long)Long.bitCount(this.readLong(i));
        }
        return count;
    }

    @Override
    public DirectBitSet and(long longIndex, long value) {
        long l = this.readLong(longIndex);
        long l2 = l & value;
        this.writeLong(longIndex, l2);
        return this;
    }

    @Override
    public DirectBitSet or(long longIndex, long value) {
        long l = this.readLong(longIndex);
        long l2 = l | value;
        this.writeLong(longIndex, l2);
        return this;
    }

    @Override
    public DirectBitSet xor(long longIndex, long value) {
        long l = this.readLong(longIndex);
        long l2 = l ^ value;
        this.writeLong(longIndex, l2);
        return this;
    }

    @Override
    public DirectBitSet andNot(long longIndex, long value) {
        long l = this.readLong(longIndex);
        long l2 = l & (value ^ 0xFFFFFFFFFFFFFFFFL);
        this.writeLong(longIndex, l2);
        return this;
    }

    @Override
    public long setNextNContinuousClearBits(long fromIndex, int numberOfBits) {
        if (numberOfBits > 64) {
            return this.setNextManyContinuousClearBits(fromIndex, numberOfBits);
        }
        SingleThreadedDirectBitSet.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.setNextClearBit(fromIndex);
        }
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long nTrailingOnes = -1L >>> 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex2 = SingleThreadedDirectBitSet.longWithThisBit(bitIndex);
        if (longIndex2 >= this.longLength) {
            return -1L;
        }
        int bitsFromFirstWord = 64 - ((int)bitIndex & 0x3F);
        long byteIndex2 = SingleThreadedDirectBitSet.firstByte(longIndex2);
        long w2 = this.bytes.readLong(byteIndex2);
        block0: while (true) {
            long w1 = w2;
            byteIndex2 += 8L;
            if (++longIndex2 < this.longLength) {
                w2 = this.bytes.readLong(byteIndex2);
            } else if (longIndex2 == this.longLength) {
                w2 = -1L;
            } else {
                return -1L;
            }
            long l = bitsFromFirstWord != 64 ? w1 >>> (int)bitIndex | w2 << bitsFromFirstWord : w1;
            if ((l & 1L) != 0L) {
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x != 0L) {
                    int trailingOnes = Long.numberOfTrailingZeros(x);
                    bitIndex += (long)trailingOnes;
                    if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                        bitsFromFirstWord += 64;
                        continue;
                    }
                    l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                } else {
                    bitIndex += 64L;
                    continue;
                }
            }
            while (true) {
                if ((l & nTrailingOnes) == 0L) {
                    long mask1 = nTrailingOnes << (int)bitIndex;
                    this.bytes.writeLong(byteIndex2 - 8L, w1 ^ mask1);
                    int bitsFromSecondWordToSwitch = numberOfBits - bitsFromFirstWord;
                    if (bitsFromSecondWordToSwitch > 0) {
                        long mask2 = SingleThreadedDirectBitSet.singleBit(bitsFromSecondWordToSwitch) - 1L;
                        this.bytes.writeLong(byteIndex2, w2 ^ mask2);
                    }
                    return bitIndex;
                }
                int trailingZeros = Long.numberOfTrailingZeros(l);
                bitIndex += (long)trailingZeros;
                if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x == 0L) break;
                int trailingOnes = Long.numberOfTrailingZeros(x);
                bitIndex += (long)trailingOnes;
                if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
            }
            bitIndex += 64L;
        }
    }

    private long setNextManyContinuousClearBits(long fromIndex, int numberOfBits) {
        long size = this.size();
        long testFromIndex = fromIndex;
        long limit;
        while ((limit = fromIndex + (long)numberOfBits) <= size) {
            long needToBeZerosUntil = limit - 1L;
            long lastSetBit = this.previousSetBit(needToBeZerosUntil, testFromIndex);
            if (lastSetBit == -1L) {
                this.set(fromIndex, limit);
                return fromIndex;
            }
            fromIndex = lastSetBit + 1L;
            testFromIndex = limit;
        }
        return -1L;
    }

    @Override
    public long clearNextNContinuousSetBits(long fromIndex, int numberOfBits) {
        SingleThreadedDirectBitSet.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.clearNextSetBit(fromIndex);
        }
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long nTrailingOnes = -1L >>> 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex2 = SingleThreadedDirectBitSet.longWithThisBit(bitIndex);
        if (longIndex2 >= this.longLength) {
            return -1L;
        }
        int bitsFromFirstWord = 64 - ((int)bitIndex & 0x3F);
        long byteIndex2 = SingleThreadedDirectBitSet.firstByte(longIndex2);
        long w2 = this.bytes.readLong(byteIndex2);
        block0: while (true) {
            long w1 = w2;
            byteIndex2 += 8L;
            if (++longIndex2 < this.longLength) {
                w2 = this.bytes.readLong(byteIndex2);
            } else if (longIndex2 == this.longLength) {
                w2 = 0L;
            } else {
                return -1L;
            }
            long l = bitsFromFirstWord != 64 ? w1 >>> (int)bitIndex | w2 << bitsFromFirstWord : w1;
            if ((l & 1L) == 0L) {
                if (l != 0L) {
                    int trailingZeros = Long.numberOfTrailingZeros(l);
                    bitIndex += (long)trailingZeros;
                    if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                        bitsFromFirstWord += 64;
                        continue;
                    }
                    l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                } else {
                    bitIndex += 64L;
                    continue;
                }
            }
            while (true) {
                if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nTrailingOnes) == 0L) {
                    long mask1 = nTrailingOnes << (int)bitIndex;
                    this.bytes.writeLong(byteIndex2 - 8L, w1 ^ mask1);
                    int bitsFromSecondWordToSwitch = numberOfBits - bitsFromFirstWord;
                    if (bitsFromSecondWordToSwitch > 0) {
                        long mask2 = SingleThreadedDirectBitSet.singleBit(bitsFromSecondWordToSwitch) - 1L;
                        this.bytes.writeLong(byteIndex2, w2 ^ mask2);
                    }
                    return bitIndex;
                }
                int trailingOnes = Long.numberOfTrailingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                bitIndex += (long)trailingOnes;
                if ((bitsFromFirstWord -= trailingOnes) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
                if (l == 0L) break;
                int trailingZeros = Long.numberOfTrailingZeros(l);
                bitIndex += (long)trailingZeros;
                if ((bitsFromFirstWord -= trailingZeros) <= 0) {
                    bitsFromFirstWord += 64;
                    continue block0;
                }
                l = w1 >>> (int)bitIndex | w2 << bitsFromFirstWord;
            }
            bitIndex += 64L;
        }
    }

    @Override
    public long setPreviousNContinuousClearBits(long fromIndex, int numberOfBits) {
        SingleThreadedDirectBitSet.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.setPreviousClearBit(fromIndex);
        }
        if (SingleThreadedDirectBitSet.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        int n64Complement = 64 - numberOfBits;
        long nLeadingOnes = SingleThreadedDirectBitSet.higherBitsIncludingThis(n64Complement);
        long higherBitBound = fromIndex + 1L;
        long lowLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (lowLongIndex >= this.longLength) {
            lowLongIndex = this.longLength - 1L;
            higherBitBound = this.longLength << 6;
        }
        int bitsFromLowWord = 64 - ((int)higherBitBound & 0x3F) & 0x3F;
        long lowByteIndex = SingleThreadedDirectBitSet.firstByte(lowLongIndex);
        long lw = this.bytes.readLong(lowByteIndex);
        block0: while (true) {
            long hw = lw;
            lowByteIndex -= 8L;
            if (--lowLongIndex >= 0L) {
                lw = this.bytes.readLong(lowByteIndex);
            } else if (lowLongIndex == -1L) {
                lw = -1L;
            } else {
                return -1L;
            }
            long l = bitsFromLowWord != 0 ? lw >>> (int)higherBitBound | hw << bitsFromLowWord : hw;
            if (l < 0L) {
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x != 0L) {
                    int leadingOnes = Long.numberOfLeadingZeros(x);
                    higherBitBound -= (long)leadingOnes;
                    int flw = (bitsFromLowWord += leadingOnes) - 64;
                    if (flw >= 0) {
                        bitsFromLowWord = flw;
                        continue;
                    }
                    l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                } else {
                    higherBitBound -= 64L;
                    continue;
                }
            }
            while (true) {
                if ((l & nLeadingOnes) == 0L) {
                    long hMask = nLeadingOnes >>> bitsFromLowWord;
                    this.bytes.writeLong(lowByteIndex + 8L, hw ^ hMask);
                    int bitsFromLowWordToSwitch = bitsFromLowWord - n64Complement;
                    if (bitsFromLowWordToSwitch > 0) {
                        long lMask = -1L >>> bitsFromLowWordToSwitch ^ 0xFFFFFFFFFFFFFFFFL;
                        this.bytes.writeLong(lowByteIndex, lw ^ lMask);
                    }
                    return higherBitBound - (long)numberOfBits;
                }
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                int flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                if (x == 0L) break;
                int leadingOnes = Long.numberOfLeadingZeros(x);
                higherBitBound -= (long)leadingOnes;
                flw = (bitsFromLowWord += leadingOnes) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            }
            higherBitBound -= 64L;
        }
    }

    @Override
    public long clearPreviousNContinuousSetBits(long fromIndex, int numberOfBits) {
        SingleThreadedDirectBitSet.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.clearPreviousSetBit(fromIndex);
        }
        if (SingleThreadedDirectBitSet.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        int n64Complement = 64 - numberOfBits;
        long nLeadingOnes = SingleThreadedDirectBitSet.higherBitsIncludingThis(n64Complement);
        long higherBitBound = fromIndex + 1L;
        long lowLongIndex = SingleThreadedDirectBitSet.longWithThisBit(fromIndex);
        if (lowLongIndex >= this.longLength) {
            lowLongIndex = this.longLength - 1L;
            higherBitBound = this.longLength << 6;
        }
        int bitsFromLowWord = 64 - ((int)higherBitBound & 0x3F) & 0x3F;
        long lowByteIndex = SingleThreadedDirectBitSet.firstByte(lowLongIndex);
        long lw = this.bytes.readLong(lowByteIndex);
        block0: while (true) {
            int flw;
            long hw = lw;
            lowByteIndex -= 8L;
            if (--lowLongIndex >= 0L) {
                lw = this.bytes.readLong(lowByteIndex);
            } else if (lowLongIndex == -1L) {
                lw = 0L;
            } else {
                return -1L;
            }
            long l = bitsFromLowWord != 0 ? lw >>> (int)higherBitBound | hw << bitsFromLowWord : hw;
            if (l > 0L) {
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            } else if (l == 0L) {
                higherBitBound -= 64L;
                continue;
            }
            while (true) {
                if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nLeadingOnes) == 0L) {
                    long hMask = nLeadingOnes >>> bitsFromLowWord;
                    this.bytes.writeLong(lowByteIndex + 8L, hw ^ hMask);
                    int bitsFromLowWordToSwitch = bitsFromLowWord - n64Complement;
                    if (bitsFromLowWordToSwitch > 0) {
                        long lMask = -1L >>> bitsFromLowWordToSwitch ^ 0xFFFFFFFFFFFFFFFFL;
                        this.bytes.writeLong(lowByteIndex, lw ^ lMask);
                    }
                    return higherBitBound - (long)numberOfBits;
                }
                int leadingOnes = Long.numberOfLeadingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                higherBitBound -= (long)leadingOnes;
                flw = (bitsFromLowWord += leadingOnes) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
                if (l == 0L) break;
                int leadingZeros = Long.numberOfLeadingZeros(l);
                higherBitBound -= (long)leadingZeros;
                flw = (bitsFromLowWord += leadingZeros) - 64;
                if (flw >= 0) {
                    bitsFromLowWord = flw;
                    continue block0;
                }
                l = lw >>> (int)higherBitBound | hw << bitsFromLowWord;
            }
            higherBitBound -= 64L;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SingleThreadedBitSet{");
        sb.append("size=" + this.size());
        sb.append(", cardinality=" + this.cardinality());
        sb.append(", bits=[");
        for (long i = 0L; i < this.longLength; ++i) {
            sb.append(Long.toBinaryString(this.readLong(i)));
        }
        sb.append("]}");
        return sb.toString();
    }

    static /* synthetic */ long access$000(SingleThreadedDirectBitSet x0) {
        return x0.longLength;
    }

    private class SetBits
    implements DirectBitSet.Bits {
        private long byteIndex = 0L;
        private final long byteLength = SingleThreadedDirectBitSet.access$000(SingleThreadedDirectBitSet.this) << 3;
        private long bitIndex = -1L;
        private long currentWord = SingleThreadedDirectBitSet.access$100(SingleThreadedDirectBitSet.this).readLong(0L);

        private SetBits() {
        }

        @Override
        public long next() {
            long l = this.currentWord;
            if (l != 0L) {
                int trailingZeros = Long.numberOfTrailingZeros(l);
                this.currentWord = l >>> trailingZeros >>> 1;
                return this.bitIndex += (long)(trailingZeros + 1);
            }
            long i = this.byteIndex;
            long lim = this.byteLength;
            while ((i += 8L) < lim) {
                l = SingleThreadedDirectBitSet.this.bytes.readLong(i);
                if (l == 0L) continue;
                this.byteIndex = i;
                int trailingZeros = Long.numberOfTrailingZeros(l);
                this.currentWord = l >>> trailingZeros >>> 1;
                this.bitIndex = (i << 3) + (long)trailingZeros;
                return this.bitIndex;
            }
            this.currentWord = 0L;
            this.byteIndex = this.byteLength;
            return -1L;
        }
    }
}

