/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.openid.appauth.AdditionalParamsProcessor;
import net.openid.appauth.AsciiStringListUtil;
import net.openid.appauth.AuthorizationManagementRequest;
import net.openid.appauth.AuthorizationManagementUtil;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import net.openid.appauth.internal.UriUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class EndSessionRequest
implements AuthorizationManagementRequest {
    @VisibleForTesting
    static final String PARAM_ID_TOKEN_HINT = "id_token_hint";
    @VisibleForTesting
    static final String PARAM_POST_LOGOUT_REDIRECT_URI = "post_logout_redirect_uri";
    @VisibleForTesting
    static final String PARAM_STATE = "state";
    @VisibleForTesting
    static final String PARAM_UI_LOCALES = "ui_locales";
    private static final Set<String> BUILT_IN_PARAMS = AdditionalParamsProcessor.builtInParams("id_token_hint", "post_logout_redirect_uri", "state", "ui_locales");
    private static final String KEY_CONFIGURATION = "configuration";
    private static final String KEY_ID_TOKEN_HINT = "id_token_hint";
    private static final String KEY_POST_LOGOUT_REDIRECT_URI = "post_logout_redirect_uri";
    private static final String KEY_STATE = "state";
    private static final String KEY_UI_LOCALES = "ui_locales";
    private static final String KEY_ADDITIONAL_PARAMETERS = "additionalParameters";
    @NonNull
    public final AuthorizationServiceConfiguration configuration;
    @Nullable
    public final String idTokenHint;
    @Nullable
    public final Uri postLogoutRedirectUri;
    @Nullable
    public final String state;
    @Nullable
    public final String uiLocales;
    @NonNull
    public final Map<String, String> additionalParameters;

    private EndSessionRequest(@NonNull AuthorizationServiceConfiguration configuration, @Nullable String idTokenHint, @Nullable Uri postLogoutRedirectUri, @Nullable String state, @Nullable String uiLocales, @NonNull Map<String, String> additionalParameters) {
        this.configuration = configuration;
        this.idTokenHint = idTokenHint;
        this.postLogoutRedirectUri = postLogoutRedirectUri;
        this.state = state;
        this.uiLocales = uiLocales;
        this.additionalParameters = additionalParameters;
    }

    @Override
    @Nullable
    public String getState() {
        return this.state;
    }

    public Set<String> getUiLocales() {
        return AsciiStringListUtil.stringToSet(this.uiLocales);
    }

    @Override
    public Uri toUri() {
        Uri.Builder uriBuilder = this.configuration.endSessionEndpoint.buildUpon();
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "id_token_hint", this.idTokenHint);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "state", this.state);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "ui_locales", this.uiLocales);
        if (this.postLogoutRedirectUri != null) {
            uriBuilder.appendQueryParameter("post_logout_redirect_uri", this.postLogoutRedirectUri.toString());
        }
        for (Map.Entry<String, String> entry : this.additionalParameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return uriBuilder.build();
    }

    @Override
    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_CONFIGURATION, this.configuration.toJson());
        JsonUtil.putIfNotNull(json, "id_token_hint", this.idTokenHint);
        JsonUtil.putIfNotNull(json, "post_logout_redirect_uri", this.postLogoutRedirectUri);
        JsonUtil.putIfNotNull(json, "state", this.state);
        JsonUtil.putIfNotNull(json, "ui_locales", this.uiLocales);
        JsonUtil.put(json, KEY_ADDITIONAL_PARAMETERS, JsonUtil.mapToJsonObject(this.additionalParameters));
        return json;
    }

    @Override
    public String jsonSerializeString() {
        return this.jsonSerialize().toString();
    }

    public static EndSessionRequest jsonDeserialize(@NonNull JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json cannot be null");
        return new EndSessionRequest(AuthorizationServiceConfiguration.fromJson(json.getJSONObject(KEY_CONFIGURATION)), JsonUtil.getStringIfDefined(json, "id_token_hint"), JsonUtil.getUriIfDefined(json, "post_logout_redirect_uri"), JsonUtil.getStringIfDefined(json, "state"), JsonUtil.getStringIfDefined(json, "ui_locales"), JsonUtil.getStringMap(json, KEY_ADDITIONAL_PARAMETERS));
    }

    @NonNull
    public static EndSessionRequest jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotNull(jsonStr, "json string cannot be null");
        return EndSessionRequest.jsonDeserialize(new JSONObject(jsonStr));
    }

    public static final class Builder {
        @NonNull
        private AuthorizationServiceConfiguration mConfiguration;
        @Nullable
        private String mIdTokenHint;
        @Nullable
        private Uri mPostLogoutRedirectUri;
        @Nullable
        private String mState;
        @Nullable
        private String mUiLocales;
        @NonNull
        private Map<String, String> mAdditionalParameters = new HashMap<String, String>();

        public Builder(@NonNull AuthorizationServiceConfiguration configuration) {
            this.setAuthorizationServiceConfiguration(configuration);
            this.setState(AuthorizationManagementUtil.generateRandomState());
        }

        @NonNull
        public Builder setAuthorizationServiceConfiguration(@NonNull AuthorizationServiceConfiguration configuration) {
            this.mConfiguration = Preconditions.checkNotNull(configuration, "configuration cannot be null");
            return this;
        }

        @NonNull
        public Builder setIdTokenHint(@Nullable String idTokenHint) {
            this.mIdTokenHint = Preconditions.checkNullOrNotEmpty(idTokenHint, "idTokenHint must not be empty");
            return this;
        }

        @NonNull
        public Builder setPostLogoutRedirectUri(@Nullable Uri postLogoutRedirectUri) {
            this.mPostLogoutRedirectUri = postLogoutRedirectUri;
            return this;
        }

        @NonNull
        public Builder setState(@Nullable String state) {
            this.mState = Preconditions.checkNullOrNotEmpty(state, "state must not be empty");
            return this;
        }

        @NonNull
        public Builder setUiLocales(@Nullable String uiLocales) {
            this.mUiLocales = Preconditions.checkNullOrNotEmpty(uiLocales, "uiLocales must be null or not empty");
            return this;
        }

        @NonNull
        public Builder setUiLocalesValues(String ... uiLocalesValues) {
            if (uiLocalesValues == null) {
                this.mUiLocales = null;
                return this;
            }
            return this.setUiLocalesValues(Arrays.asList(uiLocalesValues));
        }

        @NonNull
        public Builder setUiLocalesValues(@Nullable Iterable<String> uiLocalesValues) {
            this.mUiLocales = AsciiStringListUtil.iterableToString(uiLocalesValues);
            return this;
        }

        @NonNull
        public Builder setAdditionalParameters(@Nullable Map<String, String> additionalParameters) {
            this.mAdditionalParameters = AdditionalParamsProcessor.checkAdditionalParams(additionalParameters, BUILT_IN_PARAMS);
            return this;
        }

        @NonNull
        public EndSessionRequest build() {
            return new EndSessionRequest(this.mConfiguration, this.mIdTokenHint, this.mPostLogoutRedirectUri, this.mState, this.mUiLocales, Collections.unmodifiableMap(new HashMap<String, String>(this.mAdditionalParameters)));
        }
    }
}

