/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.browser;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openid.appauth.internal.Logger;
import net.openid.appauth.internal.UriUtil;

public class CustomTabManager {
    private static final long CLIENT_WAIT_TIME = 1L;
    @NonNull
    private final WeakReference<Context> mContextRef;
    @NonNull
    private final AtomicReference<CustomTabsClient> mClient;
    @NonNull
    private final CountDownLatch mClientLatch;
    @Nullable
    private CustomTabsServiceConnection mConnection;

    public CustomTabManager(@NonNull Context context) {
        this.mContextRef = new WeakReference<Context>(context);
        this.mClient = new AtomicReference();
        this.mClientLatch = new CountDownLatch(1);
    }

    public synchronized void bind(@NonNull String browserPackage) {
        if (this.mConnection != null) {
            return;
        }
        this.mConnection = new CustomTabsServiceConnection(){

            public void onServiceDisconnected(ComponentName componentName) {
                Logger.debug("CustomTabsService is disconnected", new Object[0]);
                this.setClient(null);
            }

            public void onCustomTabsServiceConnected(ComponentName componentName, CustomTabsClient customTabsClient) {
                Logger.debug("CustomTabsService is connected", new Object[0]);
                customTabsClient.warmup(0L);
                this.setClient(customTabsClient);
            }

            private void setClient(@Nullable CustomTabsClient client) {
                CustomTabManager.this.mClient.set(client);
                CustomTabManager.this.mClientLatch.countDown();
            }
        };
        Context context = (Context)this.mContextRef.get();
        if (context == null || !CustomTabsClient.bindCustomTabsService((Context)context, (String)browserPackage, (CustomTabsServiceConnection)this.mConnection)) {
            Logger.info("Unable to bind custom tabs service", new Object[0]);
            this.mClientLatch.countDown();
        }
    }

    @WorkerThread
    @NonNull
    public CustomTabsIntent.Builder createTabBuilder(Uri ... possibleUris) {
        return new CustomTabsIntent.Builder(this.createSession(null, possibleUris));
    }

    public synchronized void dispose() {
        if (this.mConnection == null) {
            return;
        }
        Context context = (Context)this.mContextRef.get();
        if (context != null) {
            context.unbindService((ServiceConnection)this.mConnection);
        }
        this.mClient.set(null);
        Logger.debug("CustomTabsService is disconnected", new Object[0]);
    }

    @WorkerThread
    @Nullable
    public CustomTabsSession createSession(@Nullable CustomTabsCallback callbacks, Uri ... possibleUris) {
        CustomTabsClient client = this.getClient();
        if (client == null) {
            return null;
        }
        CustomTabsSession session = client.newSession(callbacks);
        if (session == null) {
            Logger.warn("Failed to create custom tabs session through custom tabs client", new Object[0]);
            return null;
        }
        if (possibleUris != null && possibleUris.length > 0) {
            List<Bundle> additionalUris = UriUtil.toCustomTabUriBundle(possibleUris, 1);
            session.mayLaunchUrl(possibleUris[0], null, additionalUris);
        }
        return session;
    }

    @WorkerThread
    public CustomTabsClient getClient() {
        try {
            this.mClientLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.info("Interrupted while waiting for browser connection", new Object[0]);
            this.mClientLatch.countDown();
        }
        return this.mClient.get();
    }
}

