/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.LineEnding;
import net.revelc.code.formatter.Result;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MalformedTreeException;

public abstract class AbstractCacheableFormatter {
    protected Log log;
    protected Charset encoding;

    protected abstract void init(Map<String, String> var1, ConfigurationSource var2);

    protected void initCfg(ConfigurationSource cfg) {
        this.log = cfg.getLog();
        this.encoding = cfg.getEncoding();
    }

    public Result formatFile(File file, LineEnding ending, boolean dryRun) {
        try {
            this.log.debug((CharSequence)("Processing file: " + file + " with line ending: " + (Object)((Object)ending)));
            String code = FileUtils.fileRead((File)file, (String)this.encoding.name());
            String formattedCode = this.doFormat(code, ending);
            if (formattedCode == null) {
                this.log.debug((CharSequence)"Nothing formatted. Try to fix line endings.");
                formattedCode = AbstractCacheableFormatter.fixLineEnding(code, ending);
            }
            if (formattedCode == null) {
                this.log.debug((CharSequence)"Equal code. Not writing result to file.");
                return Result.SKIPPED;
            }
            if (!dryRun) {
                FileUtils.fileWrite((File)file, (String)this.encoding.name(), (String)formattedCode);
            }
            return Result.SUCCESS;
        }
        catch (IOException | BadLocationException | MalformedTreeException e) {
            this.log.warn(e);
            return Result.FAIL;
        }
    }

    private static String fixLineEnding(String code, LineEnding ending) {
        if (ending == LineEnding.KEEP) {
            return null;
        }
        LineEnding current = LineEnding.determineLineEnding(code);
        if (current == LineEnding.UNKNOWN) {
            return null;
        }
        if (current == ending) {
            return null;
        }
        if (ending == LineEnding.AUTO && Objects.equals(current.getChars(), ending.getChars())) {
            return null;
        }
        return code.replace(current.getChars(), ending.getChars());
    }

    protected abstract String doFormat(String var1, LineEnding var2) throws IOException, BadLocationException;
}

