/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml.lib;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentFormatter {
    private static final Pattern ORIGINAL_INDENT_PATTERN = Pattern.compile("^(?<indent>\\s*)-->");

    public String format(String tagText, String indent, String lineDelimiter) {
        String[] lines = tagText.split(lineDelimiter);
        String originalIndent = this.resolveOriginalIndent(lines);
        ArrayList<CallSite> newLines = new ArrayList<CallSite>();
        for (String line : lines) {
            newLines.add((CallSite)((Object)(indent + CommentFormatter.removeOriginalIndent(line, originalIndent))));
        }
        return String.join((CharSequence)lineDelimiter, newLines);
    }

    private String resolveOriginalIndent(String[] lines) {
        if (lines.length < 2) {
            return null;
        }
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i];
            if (!line.trim().endsWith("-->")) continue;
            Matcher m = ORIGINAL_INDENT_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group("indent");
            }
            return null;
        }
        return null;
    }

    private static String removeOriginalIndent(String line, String indent) {
        if (indent != null && line.startsWith(indent)) {
            return line.substring(indent.length());
        }
        return line;
    }
}

