/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import ch.lambdaj.Lambda;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.OutcomeCounter;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestType;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.ExcludedUnrelatedRequirementTypes;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsPercentageFormatter;
import net.thucydides.core.requirements.reports.RequirementsProportionCounter;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RequirementsOutcomes {
    private final List<RequirementOutcome> requirementOutcomes;
    private final TestOutcomes testOutcomes;
    private final Optional<Requirement> parentRequirement;
    private final EnvironmentVariables environmentVariables;
    private final IssueTracking issueTracking;
    private final List<? extends RequirementsTagProvider> requirementsTagProviders;
    private final ReleaseManager releaseManager;
    private final ReportNameProvider reportNameProvider;
    List<RequirementOutcome> flattenedRequirementOutcomes = null;
    public static final Integer DEFAULT_TESTS_PER_REQUIREMENT = 4;

    public RequirementsOutcomes(List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking, EnvironmentVariables environmentVariables, List<? extends RequirementsTagProvider> requirementsTagProviders, ReportNameProvider reportNameProvider) {
        this(null, requirements, testOutcomes, issueTracking, environmentVariables, requirementsTagProviders, reportNameProvider);
    }

    public RequirementsOutcomes(Requirement parentRequirement, List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking, EnvironmentVariables environmentVariables, List<? extends RequirementsTagProvider> requirementsTagProviders, ReportNameProvider reportNameProvider) {
        this.testOutcomes = testOutcomes;
        this.parentRequirement = Optional.fromNullable((Object)parentRequirement);
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
        this.requirementsTagProviders = requirementsTagProviders;
        this.requirementOutcomes = this.buildRequirementOutcomes(requirements);
        this.reportNameProvider = reportNameProvider;
        this.releaseManager = new ReleaseManager(environmentVariables, reportNameProvider);
    }

    RequirementsOutcomes(ReportNameProvider reportNameProvider, List<RequirementOutcome> requirementOutcomes, TestOutcomes testOutcomes, Optional<Requirement> parentRequirement, EnvironmentVariables environmentVariables, IssueTracking issueTracking, List<? extends RequirementsTagProvider> requirementsTagProviders, ReleaseManager releaseManager) {
        this.reportNameProvider = reportNameProvider;
        this.requirementOutcomes = requirementOutcomes;
        this.testOutcomes = testOutcomes;
        this.parentRequirement = parentRequirement;
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
        this.requirementsTagProviders = requirementsTagProviders;
        this.releaseManager = releaseManager;
    }

    private List<RequirementOutcome> buildRequirementOutcomes(List<Requirement> requirements) {
        ArrayList outcomes = Lists.newArrayList();
        for (Requirement requirement : requirements) {
            this.buildRequirements(outcomes, requirement);
        }
        return outcomes;
    }

    public RequirementsOutcomes requirementsOfType(String type) {
        ArrayList matchingRequirements = Lists.newArrayList();
        ArrayList matchingTests = Lists.newArrayList();
        for (RequirementOutcome requirementOutcome : this.getFlattenedRequirementOutcomes()) {
            if (!requirementOutcome.getRequirement().getType().equalsIgnoreCase(type)) continue;
            matchingRequirements.add(requirementOutcome.getRequirement());
            matchingTests.addAll(requirementOutcome.getTestOutcomes().getOutcomes());
        }
        return new RequirementsOutcomes(matchingRequirements, TestOutcomes.of(matchingTests), this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider).withoutUnrelatedRequirements();
    }

    private void buildRequirements(List<RequirementOutcome> outcomes, Requirement requirement) {
        TestOutcomes outcomesForRequirement = this.testOutcomes.forRequirement(requirement);
        int requirementsWithoutTests = this.countRequirementsWithoutTestsIn(requirement);
        int estimatedUnimplementedTests = requirementsWithoutTests * this.estimatedTestsPerRequirement();
        outcomes.add(new RequirementOutcome(requirement, outcomesForRequirement, requirementsWithoutTests, estimatedUnimplementedTests, this.issueTracking));
    }

    private int countRequirementsWithoutTestsIn(Requirement rootRequirement) {
        List<Requirement> flattenedRequirements = this.getFlattenedRequirements(rootRequirement);
        int requirementsWithoutTests = 0;
        for (Requirement requirement : flattenedRequirements) {
            TestOutcomes matchingOutcomes = this.testOutcomes.forRequirement(requirement);
            if (matchingOutcomes.getTotal() != 0) continue;
            ++requirementsWithoutTests;
        }
        return requirementsWithoutTests;
    }

    public int getFlattenedRequirementCount() {
        int requirementCount = 0;
        for (RequirementOutcome requirement : this.requirementOutcomes) {
            requirementCount += requirement.getFlattenedRequirementCount();
        }
        return requirementCount;
    }

    private List<Requirement> getFlattenedRequirements(Requirement rootRequirement) {
        ArrayList flattenedRequirements = Lists.newArrayList();
        flattenedRequirements.add(rootRequirement);
        flattenedRequirements.addAll(rootRequirement.getNestedChildren());
        return flattenedRequirements;
    }

    public Optional<Requirement> getParentRequirement() {
        return this.parentRequirement;
    }

    public Optional<Requirement> getGrandparentRequirement() {
        if (!this.parentRequirement.isPresent()) {
            return Optional.absent();
        }
        if (StringUtils.isEmpty((CharSequence)((Requirement)this.parentRequirement.get()).getParent())) {
            return Optional.absent();
        }
        return this.parentRequirementOf((Requirement)this.parentRequirement.get());
    }

    private Optional<Requirement> parentRequirementOf(Requirement requirement) {
        for (RequirementsTagProvider requirementsTagProvider : this.requirementsTagProviders) {
            if (!requirementsTagProvider.getParentRequirementOf(requirement).isPresent()) continue;
            return requirementsTagProvider.getParentRequirementOf(requirement);
        }
        return Optional.absent();
    }

    public int getRequirementCount() {
        return this.requirementOutcomes.size();
    }

    public List<RequirementOutcome> getRequirementOutcomes() {
        return ImmutableList.copyOf(this.requirementOutcomes);
    }

    public String getType() {
        if (this.requirementOutcomes.isEmpty()) {
            return "requirement";
        }
        return this.requirementOutcomes.get(0).getRequirement().getType();
    }

    public String getChildrenType() {
        return this.typeOfFirstChildPresent();
    }

    public List<String> getTypes() {
        List<Requirement> requirements = this.getAllRequirements();
        ArrayList<String> types = new ArrayList<String>();
        for (Requirement requirement : requirements) {
            if (types.contains(requirement.getType())) continue;
            types.add(requirement.getType());
        }
        return types;
    }

    private String typeOfFirstChildPresent() {
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            if (outcome.getRequirement().getChildren().isEmpty()) continue;
            Requirement firstChildRequirement = outcome.getRequirement().getChildren().get(0);
            return firstChildRequirement.getType();
        }
        return null;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public String toString() {
        return "RequirementsOutcomes{requirementOutcomes=" + this.requirementOutcomes + ", parentRequirement=" + this.parentRequirement + '}';
    }

    public int getCompletedRequirementsCount() {
        int completedRequirements = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isComplete()) continue;
            ++completedRequirements;
        }
        return completedRequirements;
    }

    public int getUnsuccessfulRequirementsCount() {
        return this.getErrorRequirementsCount() + this.getFailingRequirementsCount() + this.getCompromisedRequirementsCount();
    }

    public int getErrorRequirementsCount() {
        int failingRequirements = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isError()) continue;
            ++failingRequirements;
        }
        return failingRequirements;
    }

    public int getFailingRequirementsCount() {
        int failingRequirements = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isFailure()) continue;
            ++failingRequirements;
        }
        return failingRequirements;
    }

    public int getPendingRequirementsCount() {
        int total = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isPending()) continue;
            ++total;
        }
        return total;
    }

    public int getCompromisedRequirementsCount() {
        int total = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isCompromised()) continue;
            ++total;
        }
        return total;
    }

    public int getIgnoredRequirementsCount() {
        int total = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isIgnored()) continue;
            ++total;
        }
        return total;
    }

    public int getRequirementsWithoutTestsCount() {
        int requirementsWithNoTests = 0;
        for (Requirement requirement : this.getTopLevelRequirements()) {
            if (this.testsRecordedFor(requirement) || this.isPending(requirement)) continue;
            ++requirementsWithNoTests;
        }
        return requirementsWithNoTests;
    }

    private boolean isPending(Requirement requirement) {
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.getRequirement().equals(requirement) || !requirementOutcome.isPending()) continue;
            return true;
        }
        return false;
    }

    private boolean testsRecordedFor(Requirement requirement) {
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            if (!outcome.testsRequirement(requirement) || outcome.getTestCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<Requirement> getAllRequirements() {
        ArrayList allRequirements = Lists.newArrayList();
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            this.addFlattenedRequirements(outcome.getRequirement(), allRequirements);
        }
        return allRequirements;
    }

    private List<Requirement> getTopLevelRequirements() {
        ArrayList requirements = Lists.newArrayList();
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            requirements.add(outcome.getRequirement());
        }
        return requirements;
    }

    public int getTotalRequirements() {
        return this.getAllRequirements().size();
    }

    private void addFlattenedRequirements(Requirement requirement, List<Requirement> allRequirements) {
        allRequirements.add(requirement);
        for (Requirement child : requirement.getChildren()) {
            this.addFlattenedRequirements(child, allRequirements);
        }
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomes() {
        if (this.flattenedRequirementOutcomes == null) {
            this.flattenedRequirementOutcomes = this.getFlattenedRequirementOutcomes(this.requirementOutcomes);
        }
        return this.flattenedRequirementOutcomes;
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomes(List<RequirementOutcome> outcomes) {
        HashSet flattenedOutcomes = Sets.newHashSet();
        for (RequirementOutcome requirementOutcome : outcomes) {
            flattenedOutcomes.add(requirementOutcome);
            for (Requirement requirement : requirementOutcome.getRequirement().getChildren()) {
                TestOutcomes testOutcomesForRequirement = requirementOutcome.getTestOutcomes().forRequirement(requirement);
                flattenedOutcomes.add(new RequirementOutcome(requirement, testOutcomesForRequirement, this.issueTracking));
                List<Requirement> childRequirements = requirement.getChildren();
                RequirementsOutcomes childOutcomes = new RequirementsOutcomes(childRequirements, testOutcomesForRequirement, this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider).withoutUnrelatedRequirements();
                flattenedOutcomes.addAll(this.getFlattenedRequirementOutcomes(childOutcomes.getRequirementOutcomes()));
            }
        }
        return ImmutableList.copyOf((Collection)flattenedOutcomes);
    }

    public OutcomeCounter getTotal() {
        return this.count(TestType.ANY);
    }

    public OutcomeCounter count(TestType testType) {
        return new OutcomeCounter(testType, this.getTestOutcomes());
    }

    public OutcomeCounter count(String testType) {
        return this.count(TestType.valueOf(testType.toUpperCase()));
    }

    public int getTotalTestCount() {
        return this.testOutcomes.getTotal();
    }

    public RequirementsPercentageFormatter getFormattedPercentage() {
        return new RequirementsPercentageFormatter(this.getProportion());
    }

    public RequirementsPercentageFormatter getFormattedPercentage(String testType) {
        return new RequirementsPercentageFormatter(this.proportionOf(testType));
    }

    public RequirementsPercentageFormatter getFormattedPercentage(TestType testType) {
        return new RequirementsPercentageFormatter(this.proportionOf(testType));
    }

    private int totalEstimatedAndImplementedTests() {
        int totalImplementedTests = this.getTotalTestCount();
        return totalImplementedTests + this.getEstimatedUnimplementedTests();
    }

    public int getEstimatedUnimplementedTests() {
        return this.getRequirementsWithoutTestsCount() * this.estimatedTestsPerRequirement();
    }

    private int estimatedTestsPerRequirement() {
        return ThucydidesSystemProperty.THUCYDIDES_ESTIMATED_TESTS_PER_REQUIREMENT.integerFrom(this.environmentVariables, DEFAULT_TESTS_PER_REQUIREMENT);
    }

    public RequirementsProportionCounter getProportion() {
        return this.proportionOf(TestType.ANY);
    }

    public RequirementsProportionCounter proportionOf(String testType) {
        return this.proportionOf(TestType.valueOf(testType.toUpperCase()));
    }

    public RequirementsProportionCounter proportionOf(TestType testType) {
        return new RequirementsProportionCounter(testType, this.testOutcomes, this.totalEstimatedAndImplementedTests());
    }

    public RequirementsOutcomes getReleasedRequirementsFor(Release release) {
        List<Object> matchingRequirements = Lists.newArrayList();
        ArrayList matchingTestOutcomes = Lists.newArrayList();
        List<RequirementOutcome> requirementOutcomes = this.releaseManager.enrichRequirementsOutcomesWithReleaseTags(this.getRequirementOutcomes());
        for (RequirementOutcome outcome : requirementOutcomes) {
            List<TestOutcome> outcomesForRelease;
            Set<String> releaseVersions = outcome.getReleaseVersions();
            if (!releaseVersions.contains(release.getName()) || (outcomesForRelease = this.outcomesForRelease(outcome.getTestOutcomes().getOutcomes(), release.getName())).isEmpty()) continue;
            matchingTestOutcomes.addAll(outcomesForRelease);
            matchingRequirements.add(outcome.getRequirement());
        }
        matchingRequirements = this.removeRequirementsWithoutTestsFrom((List<Requirement>)matchingRequirements);
        return new RequirementsOutcomes(Lists.newArrayList((Iterable)matchingRequirements), TestOutcomes.of(matchingTestOutcomes), this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider).withoutUnrelatedRequirements();
    }

    private List<Requirement> removeRequirementsWithoutTestsFrom(List<Requirement> requirements) {
        ArrayList prunedRequirements = Lists.newArrayList();
        for (Requirement requirement : requirements) {
            if (!this.testsExistFor(requirement)) continue;
            List<Requirement> prunedChildren = this.removeRequirementsWithoutTestsFrom(requirement.getChildren());
            prunedRequirements.add(requirement.withChildren(prunedChildren));
        }
        return ImmutableList.copyOf((Collection)prunedRequirements);
    }

    private boolean testsExistFor(Requirement requirement) {
        return !this.getTestOutcomes().forRequirement(requirement).getOutcomes().isEmpty();
    }

    private List<TestOutcome> outcomesForRelease(List<? extends TestOutcome> outcomes, String releaseName) {
        this.releaseManager.enrichOutcomesWithReleaseTags(outcomes);
        return Lambda.filter((Matcher)Lambda.having(((TestOutcome)Lambda.on(TestOutcome.class)).getVersions(), (Matcher)Matchers.hasItem((Object)releaseName)), outcomes);
    }

    public RequirementsOutcomes withoutUnrelatedRequirements() {
        if (!ThucydidesSystemProperty.THUCYDIDES_EXCLUDE_UNRELATED_REQUIREMENTS.booleanFrom(this.environmentVariables, false).booleanValue()) {
            return this;
        }
        return new RequirementsOutcomes(this.reportNameProvider, this.pruned(this.requirementOutcomes), this.testOutcomes, this.parentRequirement, this.environmentVariables, this.issueTracking, this.requirementsTagProviders, this.releaseManager);
    }

    private List<RequirementOutcome> pruned(List<RequirementOutcome> requirementOutcomes) {
        ArrayList<RequirementOutcome> prunedRequirementsOutcomes = new ArrayList<RequirementOutcome>();
        for (RequirementOutcome requirementOutcome : requirementOutcomes) {
            if (this.shouldPrune(requirementOutcome)) continue;
            prunedRequirementsOutcomes.add(requirementOutcome.withoutUnrelatedRequirements());
        }
        return prunedRequirementsOutcomes;
    }

    public boolean shouldPrune(RequirementOutcome requirementOutcome) {
        return requirementOutcome.getTestCount() == 0 && ExcludedUnrelatedRequirementTypes.definedIn(this.environmentVariables).excludeUntestedRequirementOfType(requirementOutcome.getRequirement().getType());
    }
}

