/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import ch.lambdaj.Lambda;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.RemoteDriverCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserStackRemoteDriverCapabilities
implements RemoteDriverCapabilities {
    private final EnvironmentVariables environmentVariables;

    public BrowserStackRemoteDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getUrl() {
        return ThucydidesSystemProperty.BROWSERSTACK_URL.from(this.environmentVariables);
    }

    @Override
    public DesiredCapabilities getCapabilities(DesiredCapabilities capabilities) {
        this.configureBrowserStackCapabilities(capabilities);
        return capabilities;
    }

    private String getPreparedPropertyKey(String propertyKey) {
        String shortenedPropertyKey = propertyKey.replace("browserstack.", "");
        if (shortenedPropertyKey.equals("os.version")) {
            return "os_version";
        }
        if (shortenedPropertyKey.equals("browser.version")) {
            return "browser_version";
        }
        return shortenedPropertyKey;
    }

    private void configureBrowserStackCapabilities(DesiredCapabilities capabilities) {
        List browserStackProperties = Lambda.filter((Matcher)Lambda.having((Object)Lambda.on(String.class), (Matcher)Matchers.startsWith((String)"browserstack.")), this.environmentVariables.getKeys());
        for (String propertyKey : browserStackProperties) {
            String preparedPropertyKey = this.getPreparedPropertyKey(propertyKey);
            String propertyValue = this.environmentVariables.getProperty(propertyKey);
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            capabilities.setCapability(preparedPropertyKey, propertyValue);
            capabilities.setCapability(propertyKey, propertyValue);
        }
        String remotePlatform = this.environmentVariables.getProperty("remote.platform");
        if (StringUtils.isNotEmpty((CharSequence)remotePlatform)) {
            capabilities.setPlatform(Platform.valueOf((String)remotePlatform));
        }
    }
}

