/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.bootstrap;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;

class ThucydidesContext {
    private static final ThreadLocal<ThucydidesContext> contextThreadLocal = new ThreadLocal();
    private final StepFactory stepFactory;
    private BaseStepListener stepListener;
    private final ReportService reportService;
    private File outputDirectory;
    private String defaultDriver;
    private Pages pages;
    private Configuration configuration = ConfiguredEnvironment.getConfiguration();
    private WebdriverManager webdriverManager = ThucydidesWebDriverSupport.getWebdriverManager();

    private ThucydidesContext(StepListener ... additionalListeners) {
        this((String)null, additionalListeners);
    }

    private ThucydidesContext(String defaultDriver, StepListener ... additionalListeners) {
        this.outputDirectory = this.configuration.getOutputDirectory();
        this.defaultDriver = defaultDriver;
        if (defaultDriver != null) {
            this.pages = new Pages(this.getDriver());
            this.stepFactory = StepFactory.getFactory().usingPages(this.pages);
        } else {
            this.stepFactory = StepFactory.getFactory();
        }
        this.registerStepListeners(additionalListeners);
        this.reportService = new ReportService(this.outputDirectory, (Collection)ReportService.getDefaultReporters());
    }

    protected WebDriver getDriver() {
        return this.webdriverManager.getWebdriver(this.defaultDriver);
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    private void registerStepListeners(StepListener ... additionalListeners) {
        this.stepListener = this.buildBaseStepListener();
        StepEventBus.getEventBus().registerListener(this.stepListener);
        for (StepListener listener : additionalListeners) {
            StepEventBus.getEventBus().registerListener(listener);
        }
    }

    public static ThucydidesContext newContext() {
        return new ThucydidesContext(new StepListener[0]);
    }

    public static ThucydidesContext newContext(Optional<String> driver, StepListener ... listeners) {
        ThucydidesContext context = null;
        context = driver.isPresent() ? new ThucydidesContext(driver.get(), listeners) : new ThucydidesContext(listeners);
        contextThreadLocal.set(context);
        return context;
    }

    public static ThucydidesContext getCurrentContext() {
        return contextThreadLocal.get();
    }

    public void initialize(Object testCase) {
        StepAnnotations.injector().injectScenarioStepsInto(testCase, this.stepFactory);
    }

    public void generateReports() {
        this.reportService.generateReportsFor(this.latestTestOutcomes());
        this.reportService.generateConfigurationsReport();
    }

    private List<TestOutcome> latestTestOutcomes() {
        return this.stepListener.getTestOutcomes();
    }

    public void dropListeners() {
        StepEventBus.getEventBus().dropAllListeners();
    }

    private BaseStepListener buildBaseStepListener() {
        return Listeners.getBaseStepListener().withOutputDirectory(this.outputDirectory);
    }
}

