/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.environment.WebDriverConfiguredEnvironment;
import net.thucydides.core.annotations.ClearCookiesPolicy;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.annotations.RequestedDrivers;
import net.thucydides.core.annotations.UsePersistantStepLibraries;
import net.thucydides.core.configuration.WebDriverConfiguration;
import net.thucydides.core.requirements.SerenityTestCaseFinder;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverManager;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

public final class TestCaseAnnotations {
    private final Object testCase;
    private final DriverConfiguration configuration;
    private static final SerenityTestCaseFinder serenityTestCaseFinder = new SerenityTestCaseFinder();

    public TestCaseAnnotations(Object testCase, WebDriverConfiguration configuration) {
        this.testCase = testCase;
        this.configuration = configuration;
    }

    public TestCaseAnnotations(Object testCase) {
        this.testCase = testCase;
        this.configuration = WebDriverConfiguredEnvironment.getDriverConfiguration();
    }

    public static TestCaseAnnotations forTestCase(Object testCase) {
        return new TestCaseAnnotations(testCase);
    }

    public void injectDriver(WebDriver driver) {
        Optional<ManagedWebDriverAnnotatedField> webDriverField = ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(this.testCase.getClass());
        webDriverField.ifPresent(managedWebDriverAnnotatedField -> managedWebDriverAnnotatedField.setValue(this.testCase, driver));
    }

    public void injectDrivers(WebdriverManager webdriverManager) {
        this.injectDrivers(ThucydidesWebDriverSupport.getDriver(), webdriverManager);
    }

    public void injectDrivers(WebDriver defaultDriver, WebdriverManager webdriverManager) {
        List<ManagedWebDriverAnnotatedField> webDriverFields = ManagedWebDriverAnnotatedField.findAnnotatedFields(this.testCase.getClass());
        int driverCount = 1;
        String suffix = "";
        for (ManagedWebDriverAnnotatedField webDriverField : webDriverFields) {
            String driverRootName = StringUtils.isNotEmpty((CharSequence)webDriverField.getDriver()) ? webDriverField.getDriver() : this.configuredDriverType();
            String driverName = driverRootName + suffix;
            String driverOptions = webDriverField.getOptions();
            if (!ThucydidesWebDriverSupport.getDefaultDriverType().isPresent()) {
                ThucydidesWebDriverSupport.useDefaultDriver(driverName);
                ThucydidesWebDriverSupport.useDriverOptions(driverOptions);
            }
            WebDriver driver = StringUtils.isEmpty((CharSequence)driverName) ? defaultDriver : this.requestedDriverFrom(webdriverManager, webDriverField.getName(), driverName, driverOptions);
            webDriverField.setValue(this.testCase, driver);
            suffix = this.nextSuffix(driverCount++);
        }
    }

    private WebDriver requestedDriverFrom(WebdriverManager webdriverManager, String fieldName, String driverName, String driverOptions) {
        return RequestedDrivers.withEnvironmentVariables(this.configuration.getEnvironmentVariables()).andWebDriverManager(webdriverManager).requestedDriverFor(fieldName, driverName, driverOptions);
    }

    private String configuredDriverType() {
        if (ThucydidesWebDriverSupport.isInitialised() && StringUtils.isNotEmpty((CharSequence)ThucydidesWebDriverSupport.getCurrentDriverName())) {
            return ThucydidesWebDriverSupport.getCurrentDriverName();
        }
        return this.configuration.getDriverType().name();
    }

    private String nextSuffix(int driverCount) {
        return String.format(":%d", driverCount + 1);
    }

    public static boolean supportsWebTests(Class clazz) {
        return ManagedWebDriverAnnotatedField.hasManagedWebdriverField(clazz);
    }

    public boolean isUniqueSession() {
        return TestCaseAnnotations.isUniqueSession(this.testCase.getClass());
    }

    public static boolean isUniqueSession(Class<?> testClass) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testClass);
        return webDriverField.isUniqueSession();
    }

    public static boolean isWebTest(Class<?> testClass) {
        return testClass != null && ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(testClass).isPresent();
    }

    public static boolean shouldClearCookiesBeforeEachTestIn(Class<?> testClass) {
        ManagedWebDriverAnnotatedField webDriverField = ManagedWebDriverAnnotatedField.findFirstAnnotatedField(testClass);
        return webDriverField.getClearCookiesPolicy() == ClearCookiesPolicy.BeforeEachTest;
    }

    public static boolean shouldUsePersistantStepLibraries(Class<?> testClass) {
        return testClass != null && testClass.getAnnotation(UsePersistantStepLibraries.class) != null;
    }

    public static boolean isASerenityTestCase(Class<?> testClass) {
        return serenityTestCaseFinder.isSerenityTestCase(testClass);
    }
}

