/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.serenitybdd.core.pages.WithRetries;
import org.openqa.selenium.support.ui.Select;

class DropdownDeselector {
    private final WebElementFacadeImpl webElementFacade;

    public DropdownDeselector(WebElementFacadeImpl webElementFacade) {
        this.webElementFacade = webElementFacade;
    }

    public WebElementFacade all() {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        WithRetries.on(this.webElementFacade).perform(elementFacade -> {
            Select select = new Select(this.webElementFacade.getElement());
            select.deselectAll();
        }, 12);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public WebElementFacade byVisibleText(String label) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        WithRetries.on(this.webElementFacade).perform(elementFacade -> {
            Select select = new Select(this.webElementFacade.getElement());
            select.deselectByVisibleText(label);
        }, 12);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public WebElementFacade byValue(String value) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        WithRetries.on(this.webElementFacade).perform(elementFacade -> {
            Select select = new Select(this.webElementFacade.getElement());
            select.deselectByValue(value);
        }, 12);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public WebElementFacade byIndex(int indexValue) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        WithRetries.on(this.webElementFacade).perform(elementFacade -> {
            Select select = new Select(this.webElementFacade.getElement());
            select.deselectByIndex(indexValue);
        }, 12);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }
}

