/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.webdriver.driverproviders.AddCustomDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.AddEnvironmentSpecifiedDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.InsecureCertConfig;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilitySet;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class CapabilityEnhancer {
    private final EnvironmentVariables environmentVariables;
    private final FixtureProviderService fixtureProviderService;

    public CapabilityEnhancer(EnvironmentVariables environmentVariables, FixtureProviderService fixtureProviderService) {
        this.environmentVariables = environmentVariables;
        this.fixtureProviderService = fixtureProviderService;
    }

    public MutableCapabilities enhanced(MutableCapabilities capabilities, SupportedWebDriver driver) {
        Optional<TestOutcome> currentTestOutcome;
        CapabilitySet capabilitySet = new CapabilitySet(this.environmentVariables);
        this.addExtraCapabilities(capabilities, capabilitySet);
        if (InsecureCertConfig.acceptInsecureCertsDefinedIn(this.environmentVariables).orElse(false).booleanValue() && capabilities instanceof DesiredCapabilities) {
            ((DesiredCapabilities)capabilities).acceptInsecureCerts();
        }
        this.addCapabilitiesFromFixtureServicesTo(capabilities);
        AddEnvironmentSpecifiedDriverCapabilities.from(this.environmentVariables).forDriver(driver).to(capabilities);
        if (StepEventBus.getEventBus() != null && StepEventBus.getEventBus().isBaseStepListenerRegistered() && (currentTestOutcome = StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome()) != null && currentTestOutcome.isPresent()) {
            AddCustomDriverCapabilities.from(this.environmentVariables).withTestDetails(driver, currentTestOutcome.get()).to(capabilities);
        }
        if (driver.isW3CCompliant()) {
            capabilities = capabilities.merge((Capabilities)W3CCapabilities.definedIn(this.environmentVariables).withPrefix("webdriver.capabilities").asDesiredCapabilities());
        }
        return capabilities;
    }

    private void addExtraCapabilities(MutableCapabilities capabilities, CapabilitySet capabilitySet) {
        Map<String, Object> extraCapabilities = capabilitySet.getCapabilities();
        for (String capabilityName : extraCapabilities.keySet()) {
            capabilities.setCapability(capabilityName, extraCapabilities.get(capabilityName));
        }
    }

    private void addCapabilitiesFromFixtureServicesTo(MutableCapabilities capabilities) {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.addCapabilitiesTo(capabilities);
        }
    }
}

