/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.shadow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByShadow
extends By
implements By.Remotable {
    private final By target;
    private final String shadowHost;
    private final String[] innerShadowHosts;
    private final By.Remotable.Parameters params;

    protected ByShadow(By target, String shadowHost, String[] innerShadowHosts) {
        this.target = target;
        this.shadowHost = shadowHost;
        this.innerShadowHosts = innerShadowHosts;
        this.params = new By.Remotable.Parameters("shadow dom locator", (Object)(String.valueOf(target) + " inside shadow dom located by " + shadowHost));
    }

    public static ByShadow cssSelector(String target, String shadowHost, String ... innerShadowHosts) {
        return new ByShadow(By.cssSelector((String)target), shadowHost, innerShadowHosts);
    }

    public static ByShadow cssSelector(By target, String shadowHost, String ... innerShadowHosts) {
        return new ByShadow(target, shadowHost, innerShadowHosts);
    }

    public String toString() {
        ArrayList<String> allRoots = new ArrayList<String>();
        allRoots.add(this.shadowHost);
        for (String innerHost : this.innerShadowHosts) {
            allRoots.add(innerHost);
        }
        return "By Shadow DOM: find the " + String.valueOf(this.target) + " element inside shadow doms: " + String.valueOf(allRoots);
    }

    public static ByShadowBuilder css(String target) {
        return new ByShadowBuilder(By.cssSelector((String)target));
    }

    public static ByShadowBuilder located(By byLocator) {
        return new ByShadowBuilder(byLocator);
    }

    public ByShadow thenInHost(String nestedHost) {
        ArrayList<String> innerHosts = new ArrayList<String>(Arrays.asList(this.innerShadowHosts));
        innerHosts.add(nestedHost);
        return new ByShadow(this.target, this.shadowHost, innerHosts.toArray(new String[0]));
    }

    public By.Remotable.Parameters getRemoteParameters() {
        return this.params;
    }

    public WebElement findElement(SearchContext context) {
        return this.shadowHostFor(context).findElement(this.target);
    }

    public List<WebElement> findElements(SearchContext context) {
        return this.shadowHostFor(context).findElements(this.target);
    }

    private SearchContext shadowHostFor(SearchContext context) {
        WebElement shadowHostElement = context.findElement(By.cssSelector((String)this.shadowHost));
        for (String innerHost : this.innerShadowHosts) {
            shadowHostElement = shadowHostElement.getShadowRoot().findElement(By.cssSelector((String)innerHost));
        }
        return shadowHostElement.getShadowRoot();
    }

    public static class ByShadowBuilder {
        private final By target;

        public ByShadowBuilder(By target) {
            this.target = target;
        }

        public ByShadow inHost(String shadowHost) {
            return new ByShadow(this.target, shadowHost, new String[0]);
        }

        public ByShadow inHosts(String shadowHost, String ... innerShadowHosts) {
            return new ByShadow(this.target, shadowHost, innerShadowHosts);
        }
    }
}

