/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import net.serenitybdd.core.pages.PagesAnnotatedField;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.RecursiveOrCyclicStepLibraryReferenceException;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepLibraryCreator;
import net.thucydides.core.steps.StepsAnnotatedField;
import net.thucydides.core.steps.construction.StepsClassResolver;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StepAnnotations {
    private final EnvironmentVariables environmentVariables;
    private final List<StepsClassResolver> stepsClassResolvers;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepAnnotations.class);

    private StepAnnotations() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    private StepAnnotations(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.stepsClassResolvers = new ArrayList<StepsClassResolver>();
        Iterator<StepsClassResolver> resolverIterator = ServiceLoader.load(StepsClassResolver.class).iterator();
        while (resolverIterator.hasNext()) {
            this.stepsClassResolvers.add(resolverIterator.next());
        }
    }

    public static StepAnnotations injector() {
        return new StepAnnotations();
    }

    private static StepAnnotations withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        return new StepAnnotations(environmentVariables);
    }

    public void injectScenarioStepsInto(Object testCase, StepFactory stepFactory) {
        List<StepsAnnotatedField> stepsFields = StepsAnnotatedField.findOptionalAnnotatedFields(testCase.getClass());
        this.instanciateScenarioStepFields(testCase, stepFactory, stepsFields);
    }

    void injectNestedScenarioStepsInto(Object scenarioSteps, StepFactory stepFactory, Class<?> scenarioStepsClass) {
        List<StepsAnnotatedField> stepsFields = StepsAnnotatedField.findOptionalAnnotatedFields(scenarioStepsClass);
        this.instanciateScenarioStepFields(scenarioSteps, stepFactory, stepsFields);
    }

    private void instanciateScenarioStepFields(Object testCaseOrSteps, StepFactory stepFactory, List<StepsAnnotatedField> stepsFields) {
        for (StepsAnnotatedField stepsField : stepsFields) {
            this.instantiateAnyUnitiaializedSteps(testCaseOrSteps, stepFactory, stepsField);
        }
    }

    public void instrumentStepsInField(Object target, Field field, StepFactory stepFactory) {
        StepsAnnotatedField annotatedField = new StepsAnnotatedField(field);
        this.instantiateAnyUnitiaializedSteps(target, stepFactory, annotatedField);
    }

    private void instantiateAnyUnitiaializedSteps(Object testCaseOrSteps, StepFactory stepFactory, StepsAnnotatedField stepsField) {
        if (!stepsField.isInstantiated(testCaseOrSteps)) {
            this.ensureThatThisFieldIsNotCyclicOrRecursive(stepsField);
            Class<?> scenarioStepsClass = this.resolveStepsClass(stepsField.getFieldClass());
            Object steps = StepLibraryCreator.usingConfiguredCreationStrategy(stepFactory, stepsField, this.environmentVariables).initiateStepsFor(scenarioStepsClass);
            stepsField.setValue(testCaseOrSteps, steps);
            stepsField.assignActorNameIn(steps);
            this.injectNestedScenarioStepsInto(steps, stepFactory, scenarioStepsClass);
        }
    }

    private Class<?> resolveStepsClass(Class<?> originalStepsClass) {
        if (this.stepsClassResolvers.isEmpty()) {
            return originalStepsClass;
        }
        for (StepsClassResolver stepsClassResolver : this.stepsClassResolvers) {
            Class<?> resolvedClass = stepsClassResolver.resolveStepsClass(originalStepsClass);
            if (resolvedClass == null) continue;
            LOGGER.debug("Steps {} will be instantiated as {}", originalStepsClass, resolvedClass);
            return resolvedClass;
        }
        return originalStepsClass;
    }

    private void ensureThatThisFieldIsNotCyclicOrRecursive(StepsAnnotatedField stepsAnnotatedField) {
        int maxAllowedNesting;
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        long levelsOfNesting = Stream.of(stackTrace).filter(element -> element.getMethodName().equals("instantiateAnyUnitiaializedSteps")).count();
        if (levelsOfNesting > (long)(maxAllowedNesting = ThucydidesSystemProperty.SERENITY_MAXIMUM_STEP_NESTING_DEPTH.integerFrom(this.environmentVariables, 32))) {
            String message = String.format("A recursive or cyclic reference was detected for the @Steps-annotated field %s in class %s. You may need to use @Steps(shared=true) to ensure that the same step library instance is used everywhere.", stepsAnnotatedField.getFieldName(), stepsAnnotatedField.getFieldClass().getName());
            throw new RecursiveOrCyclicStepLibraryReferenceException(message);
        }
    }

    public void injectAnnotatedPagesObjectInto(Object testCase, Pages pages) {
        Optional<PagesAnnotatedField> pagesField = PagesAnnotatedField.findFirstAnnotatedField(testCase.getClass());
        if (pagesField.isPresent()) {
            pages.setDefaultBaseUrl(pagesField.get().getDefaultBaseUrl());
            pagesField.get().setValue(testCase, pages);
        }
    }

    public void injectOptionalAnnotatedPagesObjectInto(Object testCase, Pages pages) {
        Optional<PagesAnnotatedField> pagesField = PagesAnnotatedField.findOptionalAnnotatedField(testCase.getClass());
        if (pagesField.isPresent()) {
            pages.setDefaultBaseUrl(pagesField.get().getDefaultBaseUrl());
            pagesField.get().setValue(testCase, pages);
        }
    }
}

