/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.service;

import java.util.Arrays;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.statistics.service.ContextTagProvider;
import net.thucydides.core.statistics.service.InjectedTagProvider;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderStrategy;
import net.thucydides.core.steps.TestSourceType;
import net.thucydides.core.util.EnvironmentVariables;

public class CucumberTagProviderStrategy
implements TagProviderStrategy {
    private final EnvironmentVariables environmentVariables;

    public CucumberTagProviderStrategy(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public CucumberTagProviderStrategy() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public boolean canHandleTestSource(String testType) {
        return TestSourceType.TEST_SOURCE_CUCUMBER.getValue().equalsIgnoreCase(testType);
    }

    public Iterable<? extends TagProvider> getTagProviders() {
        return Arrays.asList(new FileSystemRequirementsTagProvider(this.environmentVariables), new InjectedTagProvider(this.environmentVariables), new ContextTagProvider());
    }

    public boolean hasHighPriority() {
        return false;
    }
}

