/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.markers.CanBeSilent;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.ensure.BooleanEnsure;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.DateEnsure;
import net.serenitybdd.screenplay.ensure.DescriptionOfKt;
import net.serenitybdd.screenplay.ensure.DoubleEnsure;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.FloatEnsure;
import net.serenitybdd.screenplay.ensure.KnowableBigDecimalValue;
import net.serenitybdd.screenplay.ensure.KnowableBooleanValue;
import net.serenitybdd.screenplay.ensure.KnowableDoubleValue;
import net.serenitybdd.screenplay.ensure.KnowableFloatValue;
import net.serenitybdd.screenplay.ensure.KnowableIntValue;
import net.serenitybdd.screenplay.ensure.KnowableLocalDateValue;
import net.serenitybdd.screenplay.ensure.KnowableLocalTimeValue;
import net.serenitybdd.screenplay.ensure.KnowableStringValue;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import net.serenitybdd.screenplay.ensure.PerformablePredicate;
import net.serenitybdd.screenplay.ensure.PredicateExpectation;
import net.serenitybdd.screenplay.ensure.StringEnsure;
import net.serenitybdd.screenplay.ensure.TimeEnsure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005B/\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010$\u001a\u0010\u0012\f\u0012\n '*\u0004\u0018\u00010&0&0%J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\nJ\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u000e\u00103\u001a\u0002042\u0006\u0010,\u001a\u00020\nJ\f\u00105\u001a\b\u0012\u0004\u0012\u0002060%JH\u00107\u001a5\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011082\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00109JX\u0010:\u001a;\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011082\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000;\"\u00028\u0000\u00a2\u0006\u0002\u0010<JM\u0010:\u001a;\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011082\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000=J\u0006\u0010>\u001a\u00020\u001cJH\u0010?\u001a5\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011082\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00109JX\u0010@\u001a;\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011082\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000;\"\u00028\u0000\u00a2\u0006\u0002\u0010<JM\u0010@\u001a;\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011082\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000=J$\u0010A\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b0BJ&\u0010C\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\b0BH\u0016J\b\u0010D\u001a\u00020\u001cH\u0016J$\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\n2\u0014\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u001c0\u0006Jd\u0010H\u001aV\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012!\u0012\u001f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u001c0\u0006\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u00110\r2\u0006\u0010G\u001a\u00020\nH\u0002J\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0014\u0010J\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\u0014\u0010K\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016RT\u0010\f\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0012\u001aN\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\u0014\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0015\u001aN\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\u0016\u001a5\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u0001`\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u00100\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\u0018\u001a5\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u0001`\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u00100\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R,\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006L"}, d2={"Lnet/serenitybdd/screenplay/ensure/CommonEnsure;", "A", "E", "Lnet/serenitybdd/markers/CanBeSilent;", "value", "(Ljava/lang/Object;)V", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "expectedDescription", "", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "IS_EQUAL_TO", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "Lkotlin/ParameterName;", "name", "actual", "expected", "IS_IN", "", "IS_NOT_EQUAL_TO", "IS_NOT_IN", "IS_NOT_NULL", "Lnet/serenitybdd/screenplay/ensure/PredicateExpectation;", "IS_NULL", "getExpectedDescription", "()Ljava/lang/String;", "negated", "", "silent", "getSilent", "()Z", "setSilent", "(Z)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "asABigDecimal", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "asABoolean", "Lnet/serenitybdd/screenplay/ensure/BooleanEnsure;", "asADate", "Lnet/serenitybdd/screenplay/ensure/DateEnsure;", "format", "asADouble", "Lnet/serenitybdd/screenplay/ensure/DoubleEnsure;", "asAFloat", "Lnet/serenitybdd/screenplay/ensure/FloatEnsure;", "asAString", "Lnet/serenitybdd/screenplay/ensure/StringEnsure;", "asATime", "Lnet/serenitybdd/screenplay/ensure/TimeEnsure;", "asAnInteger", "", "isEqualTo", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "(Ljava/lang/Object;)Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "isIn", "", "([Ljava/lang/Object;)Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "", "isNegated", "isNotEqualTo", "isNotIn", "isNotNull", "Lnet/serenitybdd/screenplay/ensure/PerformablePredicate;", "isNull", "isSilent", "matches", "Lnet/serenitybdd/screenplay/Performable;", "description", "matchesPredicate", "negate", "not", "silently", "serenity-ensure"})
public class CommonEnsure<A, E>
implements CanBeSilent {
    @NotNull
    private final Function1<Actor, A> value;
    @NotNull
    private final String expectedDescription;
    private boolean negated;
    private boolean silent;
    @NotNull
    private final Expectation<Function1<Actor, A>, E> IS_EQUAL_TO;
    @NotNull
    private final Expectation<Function1<Actor, A>, E> IS_NOT_EQUAL_TO;
    @NotNull
    private final PredicateExpectation<Function1<Actor, A>> IS_NULL;
    @NotNull
    private final PredicateExpectation<Function1<Actor, A>> IS_NOT_NULL;
    @NotNull
    private final Expectation<Function1<Actor, A>, List<A>> IS_IN;
    @NotNull
    private final Expectation<Function1<Actor, A>, List<A>> IS_NOT_IN;

    public CommonEnsure(@NotNull Function1<? super Actor, ? extends A> value, @NotNull String expectedDescription) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)expectedDescription, (String)"expectedDescription");
        this.value = value;
        this.expectedDescription = expectedDescription;
        this.IS_EQUAL_TO = ExpectationKt.expectThatActualIs("equal to", IS_EQUAL_TO.1.INSTANCE);
        this.IS_NOT_EQUAL_TO = ExpectationKt.expectThatActualIs("not equal to", IS_NOT_EQUAL_TO.1.INSTANCE);
        this.IS_NULL = ExpectationKt.expectThatActualIs("null", IS_NULL.1.INSTANCE);
        this.IS_NOT_NULL = ExpectationKt.expectThatActualIs("not null", IS_NOT_NULL.1.INSTANCE);
        this.IS_IN = ExpectationKt.expectThatActualIs("in", IS_IN.1.INSTANCE);
        this.IS_NOT_IN = ExpectationKt.expectThatActualIs("not in", IS_NOT_IN.1.INSTANCE);
    }

    public /* synthetic */ CommonEnsure(final Function1 function1, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = DescriptionOfKt.descriptionOf((Function1)new Function1<Actor, Function1<? super Actor, ? extends A>>(){

                @Nullable
                public final Function1<Actor, A> invoke(@NotNull Actor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return function1;
                }
            });
        }
        this(function1, string);
    }

    @NotNull
    public Function1<Actor, A> getValue() {
        return this.value;
    }

    @NotNull
    public final String getExpectedDescription() {
        return this.expectedDescription;
    }

    public CommonEnsure(A value) {
        this(new KnownValue<A>(value, String.valueOf(value)), null, 2, null);
    }

    @NotNull
    public PerformableExpectation<Function1<Actor, A>, E> isEqualTo(E expected) {
        return new PerformableExpectation(this.getValue(), this.IS_EQUAL_TO, expected, this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public PerformableExpectation<Function1<Actor, A>, E> isNotEqualTo(E expected) {
        return new PerformableExpectation(this.getValue(), this.IS_NOT_EQUAL_TO, expected, this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public PerformablePredicate<Function1<Actor, A>> isNull() {
        return new PerformablePredicate<Function1<Actor, A>>(this.getValue(), this.IS_NULL, this.isNegated(), this.expectedDescription, null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, A>> isNotNull() {
        return new PerformablePredicate<Function1<Actor, A>>(this.getValue(), this.IS_NOT_NULL, this.isNegated(), this.expectedDescription, null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, A>, List<A>> isIn(A ... expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, A>, List<A>>(this.getValue(), this.IS_IN, ArraysKt.toList((Object[])expected), this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, A>, List<A>> isIn(@NotNull Collection<? extends A> expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, A>, List<A>>(this.getValue(), this.IS_IN, CollectionsKt.toList((Iterable)expected), this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, A>, List<A>> isNotIn(A ... expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, A>, List<A>>(this.getValue(), this.IS_NOT_IN, ArraysKt.toList((Object[])expected), this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, A>, List<A>> isNotIn(@NotNull Collection<? extends A> expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, A>, List<A>>(this.getValue(), this.IS_NOT_IN, CollectionsKt.toList((Iterable)expected), this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final Performable matches(@NotNull String description, @NotNull Function1<? super A, Boolean> expected) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation(this.getValue(), this.matchesPredicate(description), expected, this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final CommonEnsure<A, E> negate() {
        this.negated = !this.negated;
        return this;
    }

    @NotNull
    public CommonEnsure<A, E> not() {
        return this.negate();
    }

    public final boolean isNegated() {
        return this.negated;
    }

    public final boolean getSilent() {
        return this.silent;
    }

    public final void setSilent(boolean bl) {
        this.silent = bl;
    }

    public boolean isSilent() {
        return this.silent;
    }

    @NotNull
    public CommonEnsure<A, E> silently() {
        this.silent = true;
        return this;
    }

    @NotNull
    public final StringEnsure asAString() {
        return new StringEnsure((Function1<? super Actor, String>)new KnowableStringValue<A>(this.getValue(), this.expectedDescription), this.expectedDescription);
    }

    @NotNull
    public final ComparableEnsure<Integer> asAnInteger() {
        return new ComparableEnsure<Integer>((Function1)new KnowableIntValue<A>(this.getValue(), this.expectedDescription), null, this.expectedDescription);
    }

    @NotNull
    public final DoubleEnsure asADouble() {
        return DoubleEnsure.Companion.fromKnowable((Function1<? super Actor, Double>)new KnowableDoubleValue<A>(this.getValue(), this.expectedDescription));
    }

    @NotNull
    public final FloatEnsure asAFloat() {
        return FloatEnsure.Companion.fromKnowable((Function1<? super Actor, Float>)new KnowableFloatValue<A>(this.getValue(), this.expectedDescription));
    }

    @NotNull
    public final ComparableEnsure<BigDecimal> asABigDecimal() {
        return new ComparableEnsure<BigDecimal>((Function1)new KnowableBigDecimalValue<A>(this.getValue(), this.expectedDescription), null, this.expectedDescription);
    }

    @NotNull
    public final DateEnsure asADate() {
        return new DateEnsure(new KnowableLocalDateValue(this.getValue(), this.expectedDescription, null, 4, null), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final DateEnsure asADate(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new DateEnsure((Function1<? super Actor, LocalDate>)new KnowableLocalDateValue<A>(this.getValue(), this.expectedDescription, format), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final TimeEnsure asATime() {
        return new TimeEnsure(new KnowableLocalTimeValue(this.getValue(), this.expectedDescription, null, 4, null), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final TimeEnsure asATime(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new TimeEnsure((Function1<? super Actor, LocalTime>)new KnowableLocalTimeValue<A>(this.getValue(), this.expectedDescription, format), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final BooleanEnsure asABoolean() {
        return new BooleanEnsure((Function1<? super Actor, Boolean>)new KnowableBooleanValue<A>(this.getValue(), this.expectedDescription));
    }

    private final Expectation<Function1<Actor, A>, Function1<A, Boolean>> matchesPredicate(String description) {
        return ExpectationKt.expectThatActualIs("a match for", matchesPredicate.1.INSTANCE, description);
    }
}

