/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.xunit.model;

import java.util.Optional;
import net.thucydides.core.reports.adaptors.xunit.model.Skip;
import net.thucydides.core.reports.adaptors.xunit.model.TestException;

public class TestCase {
    private String name;
    private String classname;
    private double time;
    private Optional<TestException> failure;
    private Optional<TestException> error;
    private Optional<Skip> skipped;
    private static final Optional<TestException> NO_FAILURE = Optional.empty();
    private static final Optional<TestException> NO_ERROR = Optional.empty();
    private static final Optional<Skip> NOT_SKIPPED = Optional.empty();

    private TestCase(String name, String classname, double time, Optional<TestException> failure, Optional<TestException> error, Optional<Skip> skip) {
        this.name = name;
        this.classname = classname;
        this.time = time;
        this.failure = failure;
        this.error = error;
        this.skipped = skip;
    }

    public static TestCase withName(String name) {
        return new TestCase(name, "", 0.0, NO_FAILURE, NO_ERROR, NOT_SKIPPED);
    }

    public TestCase andClassname(String classname) {
        return new TestCase(this.name, classname, this.time, this.error, this.failure, this.skipped);
    }

    public TestCase andTime(double time) {
        return new TestCase(this.name, this.classname, time, this.error, this.failure, this.skipped);
    }

    public TestCase withFailure(TestException failure) {
        return new TestCase(this.name, this.classname, this.time, Optional.of(failure), this.error, this.skipped);
    }

    public TestCase withError(TestException error) {
        return new TestCase(this.name, this.classname, this.time, this.failure, Optional.of(error), this.skipped);
    }

    public TestCase wasSkipped(String message) {
        return new TestCase(this.name, this.classname, this.time, this.failure, this.error, Optional.of(new Skip(message)));
    }

    public String getName() {
        return this.name;
    }

    public String getClassname() {
        return this.classname;
    }

    public double getTime() {
        return this.time;
    }

    public Optional<TestException> getFailure() {
        return this.failure;
    }

    public Optional<TestException> getError() {
        return this.error;
    }

    public Optional<Skip> getSkipped() {
        return this.skipped;
    }
}

