/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports.cucumber;

import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.requirements.model.cucumber.ExampleRowResultIcon;

public class RenderCucumber {
    public static String step(Step step) {
        return step.getKeyword() + RenderCucumber.withEscapedParameterFields(step.getText()) + "  " + RenderCucumber.renderedArgument(step);
    }

    private static String renderedArgument(Step step) {
        if (step.getDataTable() != null && step.getDataTable().isPresent()) {
            return RenderCucumber.renderedDataTable((DataTable)step.getDataTable().get());
        }
        if (step.getDocString() != null && step.getDocString().isPresent()) {
            return ((DocString)step.getDocString().get()).getContent();
        }
        return "";
    }

    public static List<String> examples(List<Examples> examples, String featureName) {
        ArrayList<String> renderedExamples = new ArrayList<String>();
        for (Examples exampleTable : examples) {
            renderedExamples.add(RenderCucumber.renderedExamples(exampleTable, featureName));
        }
        return renderedExamples;
    }

    private static String renderedExamples(Examples examples, String featureName) {
        ExampleRowResultIcon exampleRowResultIcon = new ExampleRowResultIcon(featureName);
        StringBuffer renderedTable = new StringBuffer();
        RenderCucumber.renderExampleDescriptionOf(examples);
        renderedTable.append(RenderCucumber.renderExampleDescriptionOf(examples));
        RenderCucumber.addRow(renderedTable, ((TableRow)examples.getTableHeader().get()).getCells(), " ");
        RenderCucumber.addSeparatorCells(renderedTable, ((TableRow)examples.getTableHeader().get()).getCells().size());
        for (TableRow row : examples.getTableBody()) {
            RenderCucumber.addRow(renderedTable, row.getCells(), exampleRowResultIcon.resultToken(row.getLocation().getLine()));
        }
        return renderedTable.toString();
    }

    private static String renderExampleDescriptionOf(Examples examples) {
        StringBuilder renderedTable = new StringBuilder();
        renderedTable.append(examples.getKeyword()).append(": ");
        if (examples.getName() != null) {
            renderedTable.append(examples.getName());
        }
        renderedTable.append("  ").append(System.lineSeparator());
        if (examples.getDescription() != null) {
            renderedTable.append(System.lineSeparator()).append("> ").append(examples.getDescription().trim()).append(System.lineSeparator());
        }
        renderedTable.append(System.lineSeparator());
        return renderedTable.toString();
    }

    private static String renderedDataTable(DataTable dataTable) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append("  ").append(System.lineSeparator());
        int firstRow = 0;
        TableRow header = (TableRow)dataTable.getRows().get(0);
        if (RenderCucumber.thereAreMultipleColumnsIn(dataTable)) {
            RenderCucumber.addRow(renderedTable, header.getCells());
            RenderCucumber.addSeparatorCells(renderedTable, header.getCells().size());
            ++firstRow;
        } else {
            RenderCucumber.addSeparatorCells(renderedTable, header.getCells().size());
        }
        for (int row = firstRow; row < dataTable.getRows().size(); ++row) {
            RenderCucumber.addRow(renderedTable, ((TableRow)dataTable.getRows().get(row)).getCells());
        }
        return renderedTable.toString();
    }

    private static boolean thereAreMultipleColumnsIn(DataTable dataTable) {
        return ((TableRow)dataTable.getRows().get(0)).getCells().size() > 1;
    }

    private static void addSeparatorCells(StringBuffer renderedTable, int columnCount) {
        renderedTable.append("|");
        for (int col = 0; col < columnCount; ++col) {
            renderedTable.append("-----------").append("|");
        }
        renderedTable.append("  ").append(System.lineSeparator());
    }

    private static void addRow(StringBuffer renderedTable, List<TableCell> cells) {
        RenderCucumber.addRow(renderedTable, cells, null);
    }

    private static void addRow(StringBuffer renderedTable, List<TableCell> cells, String statusToken) {
        renderedTable.append("|");
        for (TableCell cell : cells) {
            renderedTable.append(RenderCucumber.withEscapedParameterFields(cell.getValue())).append(" |");
        }
        if (statusToken != null) {
            renderedTable.append(statusToken).append(" |");
        }
        renderedTable.append("  ").append(System.lineSeparator());
    }

    private static String withEscapedParameterFields(String text) {
        return text.replace("<", "{").replace(">", "}");
    }
}

