/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.TestOutcomesContext;
import net.thucydides.model.util.EnvironmentVariables;

public class TagExclusions {
    private final EnvironmentVariables environmentVariables;
    private final List<String> excludedTags;
    private final TestOutcomes testOutcomes;
    private final List<String> ALWAYS_HIDDEN_TAGS = Arrays.asList("manual-result", "manual-test-evidence", "manual-last-tested", "singlebrowser");

    public TagExclusions(EnvironmentVariables environmentVariables, TestOutcomes testOutcomes) {
        this.environmentVariables = environmentVariables;
        this.testOutcomes = testOutcomes;
        this.excludedTags = new ArrayList<String>(EnvironmentSpecificConfiguration.from(environmentVariables).getListOfValues(ThucydidesSystemProperty.SERENITY_REPORT_EXCLUDE_TAGS));
        this.excludedTags.addAll(EnvironmentSpecificConfiguration.from(environmentVariables).getListOfValues(ThucydidesSystemProperty.HIDDEN_TAGS));
        this.excludedTags.addAll(this.ALWAYS_HIDDEN_TAGS);
    }

    public static TagExclusions usingEnvironment(EnvironmentVariables environmentVariables) {
        return new TagExclusions(environmentVariables, TestOutcomesContext.getCurrentTestOutcomes());
    }

    public static TagExclusions usingEnvironment(EnvironmentVariables environmentVariables, TestOutcomes testOutcomes) {
        return new TagExclusions(environmentVariables, testOutcomes);
    }

    public boolean doNotExclude(TestTag tag) {
        if (this.isBrowserOrPlatformContext(tag)) {
            return !this.excludedContext(tag);
        }
        return this.excludedTags.stream().noneMatch(excludedTag -> this.matches(tag, (String)excludedTag));
    }

    private boolean matches(TestTag tag, String excludedTag) {
        if (tag.equalsIgnoreCase(TestTag.withValue(excludedTag))) {
            return true;
        }
        if (excludedTag.endsWith(":*")) {
            String tagType = excludedTag.replace(":*", "");
            return tag.getType().equalsIgnoreCase(tagType);
        }
        if (excludedTag.startsWith("*:")) {
            String tagValue = excludedTag.replace("*:", "");
            return tag.getName().equalsIgnoreCase(tagValue);
        }
        return false;
    }

    private boolean isBrowserOrPlatformContext(TestTag tag) {
        return tag.isABrowser() || tag.isAPlatform() || tag.isABrowserPlatformCombination();
    }

    private boolean excludedContext(TestTag tag) {
        boolean reportPlatformAndBrowserContexts;
        if (this.testOutcomes == null) {
            return false;
        }
        boolean reportBrowserContexts = this.testOutcomes.getBrowserContexts().size() > 1;
        boolean reportPlatformContexts = this.testOutcomes.getPlatformContexts().size() > 1;
        boolean bl = reportPlatformAndBrowserContexts = reportBrowserContexts && reportPlatformContexts;
        if (tag.isABrowser() && !reportBrowserContexts) {
            return true;
        }
        if (tag.isAPlatform() && !reportPlatformContexts) {
            return true;
        }
        return tag.isABrowserPlatformCombination() && !reportPlatformAndBrowserContexts;
    }
}

