/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SpecFileFilters {
    private static final String JAVASCRIPT_SPEC_FILE_EXTENSION_PATTERN = ".*\\.(spec|test|integration|it|e2e|spec\\.e2e|spec-e2e)\\.(jsx?|mjsx?|cjsx?|tsx?|mtsx?|ctsx?)$";
    private static final String JAVASCRIPT_SPEC_FILE_NAME_PATTERN = "^(?!.*/(node_modules|jspm_packages|web_modules)/).*\\.(spec|test|integration|it|e2e|spec\\.e2e|spec-e2e)\\.(jsx?|mjsx?|cjsx?|tsx?|mtsx?|ctsx?)$";
    private static final Pattern JAVASCRIPT_SPEC_FILE_PATTERN = Pattern.compile("^(?!.*/(node_modules|jspm_packages|web_modules)/).*\\.(spec|test|integration|it|e2e|spec\\.e2e|spec-e2e)\\.(jsx?|mjsx?|cjsx?|tsx?|mtsx?|ctsx?)$");
    private static final Set<String> NARRATIVE_FILE_NAMES = new HashSet<String>(Set.of("narrative.txt", "narrative.md", "readme.md", "placeholder.txt"));

    public static FilenameFilter javascriptSpecFiles() {
        return (dir, name) -> name.matches(JAVASCRIPT_SPEC_FILE_EXTENSION_PATTERN);
    }

    public static FilenameFilter jbehaveStoryFiles() {
        return (dir, name) -> name.endsWith(".story");
    }

    public static FilenameFilter cucumberFeatureFiles() {
        return (dir, name) -> name.endsWith(".feature");
    }

    public static FileFilter thatAreJavascriptSpecFiles() {
        return file -> JAVASCRIPT_SPEC_FILE_PATTERN.matcher(file.getName().toLowerCase()).matches();
    }

    public static FileFilter thatAreNarratives() {
        return file -> NARRATIVE_FILE_NAMES.contains(file.getName().toLowerCase());
    }
}

