/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.classpath;

import java.util.Optional;
import net.serenitybdd.annotations.Narrative;
import net.serenitybdd.model.strings.Joiner;
import net.thucydides.model.requirements.annotations.NarrativeFinder;
import org.apache.commons.lang3.StringUtils;

public abstract class PackageInfoNarrative {
    public abstract Optional<String> definedInPath(String var1);

    protected Optional<Narrative> getClassLevelNarrativeFor(String path) {
        try {
            Object packageInfoPath = path.endsWith("package-info") ? path : path + ".package-info";
            return NarrativeFinder.forClass(this.getClass().getClassLoader().loadClass((String)packageInfoPath));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static PackageInfoNarrative text() {
        return new TextPackageInfoNarrative();
    }

    public static TypePackageInfoNarrative type() {
        return new TypePackageInfoNarrative();
    }

    public static class TextPackageInfoNarrative
    extends PackageInfoNarrative {
        @Override
        public Optional<String> definedInPath(String path) {
            Optional<Narrative> narrative = this.getClassLevelNarrativeFor(path);
            if (!narrative.isPresent()) {
                return Optional.empty();
            }
            String narrativeText = Joiner.on("\n").join(narrative.get().text());
            return Optional.of((narrative.get().title() + System.lineSeparator() + narrativeText).trim());
        }
    }

    public static class TypePackageInfoNarrative
    extends PackageInfoNarrative {
        @Override
        public Optional<String> definedInPath(String path) {
            Optional<Narrative> narrative = this.getClassLevelNarrativeFor(path);
            if (narrative.isPresent() && !StringUtils.isEmpty((CharSequence)narrative.get().type())) {
                return Optional.of(narrative.get().type());
            }
            return Optional.empty();
        }
    }
}

