/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.serenitybdd.reports.model.DurationDistribution;
import net.thucydides.core.reports.html.DurationReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.ResultReportingTask;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.reports.html.TagExclusions;
import net.thucydides.model.util.EnvironmentVariables;

public class ResultReports {
    public static Stream<ReportingTask> resultReportsFor(TestOutcomes testOutcomes, FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider) {
        TagExclusions exclusions = TagExclusions.usingEnvironment((EnvironmentVariables)environmentVariables, (TestOutcomes)testOutcomes);
        Stream[] streamArray = new Stream[4];
        streamArray[0] = ResultReports.resultReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes, reportNameProvider, TestTag.EMPTY_TAG);
        streamArray[1] = ResultReports.durationReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes, reportNameProvider, TestTag.EMPTY_TAG);
        streamArray[2] = testOutcomes.getTags().stream().filter(arg_0 -> ((TagExclusions)exclusions).doNotExclude(arg_0)).flatMap(tag -> ResultReports.resultReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes.withTag(tag), new ReportNameProvider(tag.getName()), tag));
        streamArray[3] = testOutcomes.getTags().stream().filter(arg_0 -> ((TagExclusions)exclusions).doNotExclude(arg_0)).flatMap(tag -> ResultReports.durationReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes.withTag(tag), new ReportNameProvider(tag.getName()), tag));
        return Stream.of(streamArray).flatMap(stream -> stream);
    }

    private static Stream<ReportingTask> resultReportsFor(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomesForThisTag, ReportNameProvider reportName, TestTag tag) {
        ArrayList<ReportingTask> tasks = new ArrayList<ReportingTask>();
        List allResults = testOutcomesForThisTag.getAllResults();
        if (allResults.contains(TestResult.SUCCESS)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getPassingTests(), reportName, tag, "success"));
        }
        if (allResults.contains(TestResult.PENDING)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getPendingTests(), reportName, tag, "pending"));
        }
        if (allResults.contains(TestResult.FAILURE) || allResults.contains(TestResult.ERROR)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getUnsuccessfulTests(), reportName, tag, "broken"));
        }
        if (allResults.contains(TestResult.FAILURE)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getFailingTests(), reportName, tag, "failure"));
        }
        if (allResults.contains(TestResult.ABORTED)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getAbortedTests(), reportName, tag, "aborted"));
        }
        if (allResults.contains(TestResult.ERROR)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getErrorTests(), reportName, tag, "error"));
        }
        if (allResults.contains(TestResult.COMPROMISED)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getCompromisedTests(), reportName, tag, "compromised"));
        }
        if (allResults.contains(TestResult.IGNORED)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.havingResult(TestResult.IGNORED), reportName, tag, "ignored"));
        }
        if (allResults.contains(TestResult.SKIPPED)) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.havingResult(TestResult.SKIPPED), reportName, tag, "skipped"));
        }
        return tasks.stream();
    }

    private static Stream<ReportingTask> durationReportsFor(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomesForThisTag, ReportNameProvider reportName, TestTag currentTag) {
        ArrayList tasks = new ArrayList();
        if (ThucydidesSystemProperty.SERENITY_REPORT_TEST_DURATIONS.booleanFrom(environmentVariables, Boolean.valueOf(true)).booleanValue()) {
            DurationDistribution durationDistribution = new DurationDistribution(environmentVariables, testOutcomesForThisTag);
            durationDistribution.getDurationBuckets().forEach(bucket -> {
                if (!bucket.getOutcomes().isEmpty()) {
                    String label = "Duration " + bucket.getDuration();
                    if (!currentTag.getCompleteName().isEmpty()) {
                        label = currentTag.getName() + " > " + label;
                    }
                    tasks.add(ResultReports.durationReport(freemarker, environmentVariables, outputDirectory, TestOutcomes.of((Collection)bucket.getTestOutcomes()).withLabel(label), reportName, currentTag, bucket.getDuration()));
                }
            });
        }
        return tasks.stream();
    }

    private static ReportingTask resultReport(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag, String testResult) {
        return new ResultReportingTask(freemarker, environmentVariables, outputDirectory, testOutcomes, reportName, tag, testResult);
    }

    private static ReportingTask durationReport(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag, String testResult) {
        return new DurationReportingTask(freemarker, environmentVariables, outputDirectory, testOutcomes, reportName, tag, testResult);
    }
}

