/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.actions.Scroll;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnsureFieldVisible {
    private final Actor actor;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static EnsureFieldVisible ensureThat(Actor actor) {
        return new EnsureFieldVisible(actor);
    }

    private EnsureFieldVisible(Actor actor) {
        this.actor = actor;
    }

    public void canSee(WebElementFacade targetElement) {
        if (targetElement != null && !targetElement.isCurrentlyVisible()) {
            try {
                this.actor.attemptsTo(new Performable[]{Scroll.to((WebElement)targetElement)});
            }
            catch (WebDriverException failedToMoveToElement) {
                this.logger.warn("Failed to move to target", (Throwable)failedToMoveToElement);
            }
        }
    }
}

