/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import net.serenitybdd.screenplay.ui.TargetFactory;
import org.openqa.selenium.By;

public class Link {
    private static final String BY_NAME_OR_ID = "css:a[id='{0}'],a[name='{0}'],a[data-test='{0}'],a[aria-label='{0}']";
    private static final String BY_LINK_TEXT = ".//a[translate(normalize-space(.),\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\")=translate(\"{0}\",\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\")]";
    private static final String BY_PARTIAL_LINK_TEXT = ".//a[contains(translate(normalize-space(.),\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\"),translate(\"{0}\",\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\"))]";
    private static final String STARTING_WITH = ".//a[starts-with(translate(normalize-space(.),\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\"),translate(\"{0}\",\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\"))]";
    private static final String BY_LINK_TITLE = "css:a[title='{0}' i]";
    private static final String BY_ICON = ".//a[./i[contains(@class,'{0}')]]";

    public static SearchableTarget withNameOrId(String name) {
        return Target.the("the '" + name + "' link").locatedBy(BY_NAME_OR_ID).of(name);
    }

    public static SearchableTarget withCSSClass(String className) {
        return TargetFactory.forElementOfType("link").withCSSClass(className);
    }

    public static SearchableTarget withText(String name) {
        return Target.the("the '" + name + "' link").locatedByFirstMatching(BY_LINK_TEXT).of(name);
    }

    public static SearchableTarget containing(String text) {
        return Target.the("'" + text + "' link").locatedByFirstMatching(BY_PARTIAL_LINK_TEXT).of(text);
    }

    public static SearchableTarget startingWith(String text) {
        return Target.the("'" + text + "' link").locatedByFirstMatching(STARTING_WITH).of(text);
    }

    public static SearchableTarget withTitle(String title) {
        return Target.the("link entitled '" + title + "'").locatedByFirstMatching(BY_LINK_TITLE).of(CSSAttributeValue.withEscapedQuotes(title));
    }

    public static SearchableTarget withIcon(String icon) {
        return Target.the("link with icon '" + icon + "'").locatedByFirstMatching(BY_ICON).of(icon);
    }

    public static SearchableTarget locatedBy(String selector) {
        return TargetFactory.forElementOfType("link").locatedByXPathOrCss(selector);
    }

    public static SearchableTarget located(By selector) {
        return TargetFactory.forElementOfType("link").locatedBy(selector);
    }
}

