/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BidiFlag;
import com.ibm.as400.access.BidiFlagSet;
import com.ibm.as400.access.BidiText;
import com.ibm.as400.access.BidiTransform;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.sql.SQLException;

public class AS400BidiTransform {
    static final int ST1 = 1;
    static final int ST2 = 2;
    static final int ST3 = 3;
    static final int ST4 = 4;
    static final int ST5 = 5;
    static final int ST6 = 6;
    static final int ST7 = 7;
    static final int ST8 = 8;
    static final int ST9 = 9;
    static final int ST10 = 10;
    static final int ST11 = 11;
    static final int ST12 = 12;
    static final int ST13 = 13;
    static final int ST14 = 14;
    private static final int[][] CCSID_TABLE = new int[][]{{420, 4}, {424, 4}, {425, 5}, {856, 5}, {862, 4}, {864, 5}, {867, 4}, {916, 5}, {1046, 5}, {1089, 5}, {1255, 5}, {1256, 5}, {5012, 5}, {5351, 5}, {5352, 5}, {8612, 5}, {8616, 10}, {9238, 5}, {12708, 7}, {12712, 10}, {13488, 10}, {16804, 4}, {17248, 5}, {61952, 10}, {62208, 4}, {62209, 10}, {62210, 4}, {62211, 5}, {62212, 10}, {62213, 5}, {62214, 5}, {62215, 4}, {62216, 6}, {62217, 8}, {62218, 4}, {62219, 11}, {62220, 6}, {62221, 6}, {62222, 6}, {62223, 6}, {62224, 6}, {62225, 6}, {62226, 6}, {62227, 6}, {62228, 6}, {62229, 8}, {62230, 8}, {62231, 8}, {62232, 8}, {62233, 8}, {62234, 9}, {62235, 6}, {62236, 10}, {62237, 8}, {62238, 10}, {62239, 10}, {62240, 11}, {62241, 11}, {62242, 11}, {62243, 11}, {62244, 11}, {62245, 10}, {62251, 6}};
    private static final int CCSID_MAX = CCSID_TABLE.length - 1;
    private static final BidiFlagSet[] FLAG_SET = new BidiFlagSet[12];
    private static final BidiFlagSet NORMAL_FLAG_SET = AS400BidiTransform.initFlagSet(0);
    private int as400Ccsid_;
    private int as400Type_;
    private int javaType_;
    private BidiTransform bdxJ2A_ = new BidiTransform();
    private BidiTransform bdxA2J_;
    private BidiTransform lastTransform_ = this.bdxA2J_ = new BidiTransform();

    public AS400BidiTransform(int n) {
        this.bdxA2J_.flags = new BidiFlagSet(NORMAL_FLAG_SET);
        this.setAS400Ccsid(n);
        this.setJavaStringType(0);
    }

    public static boolean isBidiCcsid(int n) {
        switch (n) {
            case 420: 
            case 424: 
            case 425: 
            case 856: 
            case 862: 
            case 864: 
            case 867: 
            case 916: 
            case 1046: 
            case 1089: 
            case 1255: 
            case 1256: 
            case 5012: 
            case 5351: 
            case 5352: 
            case 8612: 
            case 8616: 
            case 9238: 
            case 12708: 
            case 12712: 
            case 13488: 
            case 16804: 
            case 17248: 
            case 61952: 
            case 62208: 
            case 62209: 
            case 62210: 
            case 62211: 
            case 62212: 
            case 62213: 
            case 62214: 
            case 62215: 
            case 62216: 
            case 62217: 
            case 62218: 
            case 62219: 
            case 62220: 
            case 62221: 
            case 62222: 
            case 62223: 
            case 62224: 
            case 62225: 
            case 62226: 
            case 62227: 
            case 62228: 
            case 62229: 
            case 62230: 
            case 62231: 
            case 62232: 
            case 62233: 
            case 62234: 
            case 62235: 
            case 62236: 
            case 62237: 
            case 62238: 
            case 62239: 
            case 62240: 
            case 62241: 
            case 62242: 
            case 62243: 
            case 62244: 
            case 62245: 
            case 62251: {
                return true;
            }
        }
        return false;
    }

    public static boolean isVisual(int n) {
        int n2 = AS400BidiTransform.getStringType(n);
        return n2 == 4 || n2 == 7 || n2 == 8 || n2 == 9;
    }

    public void setAS400Ccsid(int n) {
        this.as400Ccsid_ = n;
        this.setAS400StringType(AS400BidiTransform.getStringType(n));
    }

    public int getAS400Ccsid() {
        return this.as400Ccsid_;
    }

    public void setAS400StringType(int n) {
        this.as400Type_ = n;
        if (FLAG_SET[n] == null) {
            AS400BidiTransform.FLAG_SET[n] = AS400BidiTransform.initFlagSet(n);
        }
        this.bdxJ2A_.flags = FLAG_SET[n];
    }

    public int getAS400StringType() {
        return this.as400Type_;
    }

    public void setJavaStringType(int n) {
        this.javaType_ = n;
        this.bdxA2J_.flags = AS400BidiTransform.initFlagSet(n);
    }

    public int getJavaStringType() {
        return this.javaType_;
    }

    public void setBidiConversionProperties(BidiConversionProperties bidiConversionProperties) {
        this.setJavaStringType(bidiConversionProperties.getBidiStringType());
        bidiConversionProperties.copyOptionsTo(this.bdxJ2A_);
        bidiConversionProperties.copyOptionsTo(this.bdxA2J_);
        if (bidiConversionProperties.isBidiRemoveMarksOnImplicitToVisual()) {
            this.bdxJ2A_.removeMarkers = true;
            this.bdxA2J_.removeMarkers = false;
        }
    }

    public BidiConversionProperties getBidiConversionProperties() {
        boolean bl = this.bdxJ2A_.removeMarkers && !this.bdxA2J_.removeMarkers;
        return new BidiConversionProperties(this.getJavaStringType(), this.lastTransform_, bl);
    }

    public String toJavaLayout(String string) {
        this.lastTransform_ = this.bdxA2J_;
        if (this.as400Type_ == -1 || this.javaType_ == -1 || this.javaType_ == this.as400Type_) {
            return string;
        }
        BidiText bidiText = new BidiText(this.bdxJ2A_.flags, string);
        return bidiText.transform(this.bdxA2J_).toString();
    }

    public String toAS400Layout(String string) {
        this.lastTransform_ = this.bdxJ2A_;
        if (this.as400Type_ == -1 || this.javaType_ == -1 || this.javaType_ == this.as400Type_) {
            return string;
        }
        BidiText bidiText = new BidiText(this.bdxA2J_.flags, string);
        return bidiText.transform(this.bdxJ2A_).toString();
    }

    public static int getStringType(int n) {
        int n2 = 0;
        int n3 = CCSID_MAX;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            if (n < CCSID_TABLE[n4][0]) {
                n3 = n4 - 1;
                continue;
            }
            if (n > CCSID_TABLE[n4][0]) {
                n2 = n4 + 1;
                continue;
            }
            return CCSID_TABLE[n4][1];
        }
        if (n2 == n3 && n == CCSID_TABLE[n2][0]) {
            return CCSID_TABLE[n2][1];
        }
        return 0;
    }

    static int getStringTypeM(int n) {
        if (n == 13488 || n == 1200) {
            return 5;
        }
        return AS400BidiTransform.getStringType(n);
    }

    public static int getStringTypeX(int n, AS400 aS400) {
        if (aS400 == null) {
            return AS400BidiTransform.getStringType(n);
        }
        if (n == 13488 || n == 1200) {
            boolean bl = false;
            try {
                bl = aS400.getVersion() == 5 && aS400.getRelease() == 1;
            }
            catch (AS400SecurityException aS400SecurityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (AS400BidiTransform.isBidiCcsid(aS400.getCcsid()) && !bl) {
                return 10;
            }
            return 5;
        }
        return AS400BidiTransform.getStringType(n);
    }

    private static BidiFlagSet initFlagSet(int n) {
        switch (n) {
            case 4: {
                return new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_LTR, BidiFlag.TEXT_SHAPED, BidiFlag.SWAP_NO);
            }
            case 5: {
                return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_LTR, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
            }
            case 6: {
                return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_RTL, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
            }
            case 7: {
                return new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_CONTEXT_LTR, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_NO);
            }
            case 8: {
                return new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_RTL, BidiFlag.TEXT_SHAPED, BidiFlag.SWAP_NO);
            }
            case 9: {
                return new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_RTL, BidiFlag.TEXT_SHAPED, BidiFlag.SWAP_YES);
            }
            case 10: {
                return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_CONTEXT_LTR, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
            }
            case 11: {
                return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_CONTEXT_RTL, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
            }
        }
        return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_LTR, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
    }

    public static String bidiTransform(String string, int n, int n2) {
        BidiFlagSet bidiFlagSet;
        if (Trace.traceOn_) {
            Trace.log(5, "Bidi layout transformation from " + n + " to " + n2 + ", string: " + string);
        }
        if (n == n2) {
            return string;
        }
        if (n == -1 || n2 == -1) {
            return string;
        }
        BidiTransform bidiTransform = new BidiTransform();
        BidiFlagSet bidiFlagSet2 = AS400BidiTransform.initFlagSet(n);
        bidiTransform.flags = bidiFlagSet = AS400BidiTransform.initFlagSet(n2);
        bidiTransform.removeMarkers = true;
        BidiText bidiText = new BidiText(bidiFlagSet2, string);
        BidiText bidiText2 = bidiText.transform(bidiTransform);
        String string2 = bidiText2.toString();
        return string2;
    }

    public static String SQL_statement_reordering(String object, int n, int n2) {
        if (Trace.traceOn_) {
            Trace.log(5, "Bidi layout transformation from " + n + " to " + n2 + " of SQL statement: " + (String)object);
        }
        if (n == n2) {
            return object;
        }
        if (n == -1 || n2 == -1) {
            return object;
        }
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < ((String)object).length()) {
            String string;
            if (bl && (((String)object).charAt(n3) == '\n' || ((String)object).charAt(n3) == '\r')) {
                n5 = n3;
                string = ((String)object).substring(n4, n5);
                string = AS400BidiTransform.bidiTransform(string, n, n2);
                object = ((String)object).substring(0, n4) + string + ((String)object).substring(n5);
                n4 = n3 + 1;
            }
            if (((String)object).charAt(n3) == '\'') {
                if (bl) {
                    if (n3 + 1 < ((String)object).length() && ((String)object).charAt(n3 + 1) == '\'') {
                        n3 += 2;
                        continue;
                    }
                    n5 = n3;
                    string = ((String)object).substring(n4, n5);
                    string = AS400BidiTransform.bidiTransform(string, n, n2);
                    object = ((String)object).substring(0, n4) + string + ((String)object).substring(n5);
                    n5 = 0;
                    n4 = 0;
                    bl = false;
                } else {
                    bl = true;
                    n4 = n3 + 1;
                }
            }
            ++n3;
        }
        return object;
    }

    public static String meta_data_reordering(String object, int n, int n2) {
        if (Trace.traceOn_) {
            Trace.log(5, "Bidi layout transformation of SQL meta-data: " + (String)object);
        }
        if (n == n2) {
            return object;
        }
        if (n == -1 || n2 == -1) {
            return object;
        }
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < ((String)object).length(); ++i) {
            if (((String)object).charAt(i) != '\"') continue;
            if (bl) {
                n4 = i;
                String string = ((String)object).substring(n3, n4);
                string = AS400BidiTransform.bidiTransform(string, n, n2);
                object = ((String)object).substring(0, n3) + string + ((String)object).substring(n4);
                n4 = 0;
                n3 = 0;
                bl = false;
                continue;
            }
            bl = true;
            n3 = i + 1;
        }
        return object;
    }

    static String convertSQLToHostCCSID(String string, AS400JDBCConnection aS400JDBCConnection) throws SQLException {
        int n;
        if (aS400JDBCConnection == null || string == null) {
            return string;
        }
        JDProperties jDProperties = aS400JDBCConnection.getProperties();
        int n2 = jDProperties.getInt(42);
        if (aS400JDBCConnection.getSystem() != null) {
            int n3 = aS400JDBCConnection.getSystem().getCcsid();
            n = AS400BidiTransform.getStringType(n3);
        } else {
            n = 4;
        }
        int n4 = aS400JDBCConnection.getProperties().getInt(51);
        int n5 = AS400BidiTransform.getStringTypeX(n4, aS400JDBCConnection.getSystem());
        if (n2 != -1 && n != -1) {
            if (jDProperties.getString(60).equalsIgnoreCase("true")) {
                string = AS400BidiTransform.meta_data_reordering(string, n2, n);
            }
            string = AS400BidiTransform.SQL_statement_reordering(string, n2, n5);
        }
        return string;
    }

    static String convertDataFromHostCCSID(String string, AS400JDBCConnection aS400JDBCConnection, int n) throws SQLException {
        if (aS400JDBCConnection == null || string == null) {
            return string;
        }
        JDProperties jDProperties = aS400JDBCConnection.getProperties();
        int n2 = jDProperties.getInt(42);
        int n3 = AS400BidiTransform.getStringTypeX(n, aS400JDBCConnection.getSystem());
        if (n3 == 0) {
            if (aS400JDBCConnection.getSystem() != null) {
                n = aS400JDBCConnection.getSystem().getCcsid();
                n3 = AS400BidiTransform.getStringType(n);
            } else {
                n3 = 4;
            }
        }
        if (n2 != 0 && n3 != 0) {
            string = AS400BidiTransform.bidiTransform(string, n3, n2);
        }
        return string;
    }
}

