/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FTP;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;

public class AS400FTP
extends FTP
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_;
    private transient boolean connected_ = false;
    private transient boolean inConnect_ = false;
    private transient boolean inSaveFileProcessing_ = false;
    private String saveFilePublicAuthority_ = "*EXCLUDE";
    private String CDToRoot = "/";
    private static ResourceBundleLoader loader_;

    public AS400FTP() {
    }

    public AS400FTP(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    @Override
    public synchronized OutputStream append(String string) throws IOException {
        OutputStream outputStream = null;
        if (this.connect()) {
            this.saveFileProcessing(string);
            try {
                outputStream = super.append(string);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean append(String string, String string2) throws IOException {
        boolean bl = false;
        if (this.connect()) {
            this.saveFileProcessing(string2);
            try {
                bl = super.append(string, string2);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean append(File file, String string) throws IOException {
        boolean bl = false;
        if (this.connect()) {
            this.saveFileProcessing(string);
            try {
                bl = super.append(file, string);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return bl;
    }

    @Override
    public boolean cd(String string) throws IOException {
        if (this.connect()) {
            return super.cd(string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean connect() throws UnknownHostException, IOException, IllegalStateException {
        if (!this.connected_) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            try {
                this.system_.signon(false);
            }
            catch (AS400SecurityException aS400SecurityException) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Security exception in getVRM()", (Throwable)aS400SecurityException);
                }
                IOException iOException = new IOException(aS400SecurityException.getMessage());
                try {
                    iOException.initCause(aS400SecurityException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw iOException;
            }
            AS400ImplRemote aS400ImplRemote = (AS400ImplRemote)this.system_.getImpl();
            Socket socket = aS400ImplRemote.getConnection(super.getPort());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            super.externallyConnected(this.system_.getSystemName(), socket, bufferedReader, printWriter);
            this.connected_ = true;
            this.inConnect_ = true;
            try {
                if (!this.cd(this.CDToRoot) && Trace.isTraceOn()) {
                    Trace.log(1, "CD to root failed " + this.getLastMessage());
                }
            }
            finally {
                this.inConnect_ = false;
            }
            if (this.connected_) {
                super.fireEvent(0);
            }
        }
        return this.connected_;
    }

    @Override
    public String[] dir() throws IOException {
        if (this.connect()) {
            return super.dir();
        }
        return new String[0];
    }

    @Override
    public String[] dir(String string) throws IOException {
        if (this.connect()) {
            return super.dir(string);
        }
        return new String[0];
    }

    @Override
    public InputStream get(String string) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(string);
        }
        return null;
    }

    @Override
    public boolean get(String string, String string2) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(string, string2);
        }
        return false;
    }

    @Override
    public boolean get(String string, File file) throws IOException, FileNotFoundException {
        if (this.connect()) {
            return super.get(string, file);
        }
        return false;
    }

    @Override
    public synchronized String getCurrentDirectory() throws IOException {
        if (this.connect()) {
            return super.getCurrentDirectory();
        }
        return null;
    }

    public String getSaveFilePublicAuthority() {
        return this.saveFilePublicAuthority_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    @Override
    public synchronized String issueCommand(String string) throws IOException {
        boolean bl = true;
        if (!this.inConnect_) {
            bl = this.connect();
        }
        if (bl) {
            return super.issueCommand(string);
        }
        return null;
    }

    @Override
    public String[] ls() throws IOException {
        if (this.connect()) {
            return super.ls();
        }
        return new String[0];
    }

    @Override
    public String[] ls(String string) throws IOException {
        if (this.connect()) {
            return super.ls(string);
        }
        return new String[0];
    }

    @Override
    public boolean noop() throws IOException {
        boolean bl = true;
        if (!this.inConnect_) {
            bl = this.connect();
        }
        if (bl) {
            return super.noop();
        }
        return false;
    }

    @Override
    public synchronized OutputStream put(String string) throws IOException {
        OutputStream outputStream = null;
        if (this.connect()) {
            this.saveFileProcessing(string);
            try {
                outputStream = super.put(string);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean put(String string, String string2) throws IOException {
        boolean bl = false;
        if (this.connect()) {
            this.saveFileProcessing(string2);
            try {
                bl = super.put(string, string2);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean put(File file, String string) throws IOException {
        boolean bl = false;
        if (this.connect()) {
            this.saveFileProcessing(string);
            try {
                bl = super.put(file, string);
            }
            finally {
                this.inSaveFileProcessing_ = false;
            }
        }
        return bl;
    }

    @Override
    public synchronized String pwd() throws IOException {
        if (this.connect()) {
            return super.pwd();
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.connected_ = false;
        this.inConnect_ = false;
        this.inSaveFileProcessing_ = false;
    }

    private void saveFileProcessing(String object) throws IOException {
        block26: {
            if (!this.inSaveFileProcessing_) {
                this.inSaveFileProcessing_ = true;
                object = ((String)object).toUpperCase();
                if (((String)(object = ((String)object).trim())).endsWith(".SAVF")) {
                    Object object2;
                    if (!((String)object).startsWith("/")) {
                        object2 = this.pwd();
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "pwd: " + (String)object2);
                        }
                        if (object2 == null) {
                            return;
                        }
                        if (((String)object2).startsWith("257")) {
                            int n;
                            int n2 = ((String)object2).indexOf("\"");
                            if (n2 < 0) {
                                return;
                            }
                            if ((n = ((String)object2).indexOf("\"", ++n2)) < n2) {
                                return;
                            }
                            object2 = ((String)object2).substring(n2, n);
                            if (Trace.isTraceOn()) {
                                Trace.log(1, n2 + " " + n + " " + (String)object2);
                            }
                        } else {
                            return;
                        }
                        object = ((String)object2).endsWith("/") ? (String)object2 + (String)object : (String)object2 + "/" + (String)object;
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "target: " + (String)object);
                    }
                    try {
                        object2 = new QSYSObjectPathName((String)object);
                        CommandCall commandCall = new CommandCall(this.system_);
                        String string = "CRTSAVF  FILE(" + ((QSYSObjectPathName)object2).getLibraryName() + "/" + ((QSYSObjectPathName)object2).getObjectName() + ") AUT(" + this.saveFilePublicAuthority_ + ")";
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "command string " + string);
                        }
                        try {
                            commandCall.setCommand(string);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        commandCall.suggestThreadsafe(false);
                        try {
                            boolean bl = commandCall.run();
                            AS400Message[] aS400MessageArray = commandCall.getMessageList();
                            String string2 = aS400MessageArray[0].getText();
                            if (Trace.isTraceOn()) {
                                Trace.log(1, "message[0]: " + string2);
                            }
                            if (!bl && aS400MessageArray[0].getID().startsWith("CPF5813")) {
                                bl = true;
                            }
                            if (!bl) {
                                String string3 = " ";
                                string3 = ResourceBundleLoader.getText("CREATE_SAVE_FILE_FAILED");
                                throw new IOException(string3 + string2);
                            }
                        }
                        catch (Exception exception) {
                            if (Trace.isTraceOn()) {
                                Trace.log(1, "IO Exception running command call ", (Throwable)exception);
                            }
                            IOException iOException = new IOException(exception.getMessage());
                            try {
                                iOException.initCause(exception);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw iOException;
                        }
                        this.setDataTransferType(1);
                    }
                    catch (IllegalPathNameException illegalPathNameException) {
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "the put ends up in ifs");
                        }
                        break block26;
                    }
                }
                if (Trace.isTraceOn()) {
                    Trace.log(1, "the put is not for a save file ");
                }
            }
        }
    }

    @Override
    public synchronized boolean setCurrentDirectory(String string) throws IOException {
        if (this.connect()) {
            return super.setCurrentDirectory(string);
        }
        return false;
    }

    @Override
    public void setDataTransferType(int n) throws IOException {
        if (this.connect()) {
            super.setDataTransferType(n);
        }
    }

    @Override
    public void setPassword(String string) {
        if (!this.inConnect_) {
            throw new IllegalStateException("password");
        }
        super.setPassword(string);
    }

    public void setSaveFilePublicAuthority(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("saveFilePublicAuthority");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("saveFilePublicAuthority");
        }
        String string2 = this.saveFilePublicAuthority_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("saveFilePublicAuthority", string2, string);
        }
        this.saveFilePublicAuthority_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("saveFilePublicAuthority", string2, string);
        }
    }

    @Override
    public void setServer(String string) throws PropertyVetoException {
        if (!this.inConnect_) {
            throw new IllegalStateException("server");
        }
        super.setServer(string);
    }

    public synchronized void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.system_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("system", aS4002, aS400);
        }
        this.system_ = aS400;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("system", aS4002, aS400);
        }
    }

    @Override
    public void setUser(String string) throws PropertyVetoException {
        if (!this.inConnect_) {
            throw new IllegalStateException("user");
        }
        super.setUser(string);
    }
}

