/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class AS400GenAuthTknReplyDS
extends ClientAccessDataStream {
    AS400GenAuthTknReplyDS() {
    }

    @Override
    public Object getNewDataStream() {
        return new AS400GenAuthTknReplyDS();
    }

    int getRC() {
        return this.get32bit(20);
    }

    byte[] getProfileTokenBytes() {
        byte[] byArray = new byte[32];
        System.arraycopy(this.data_, 30, byArray, 0, 32);
        return byArray;
    }

    AS400Message[] getErrorMessages(ConverterImplRemote converterImplRemote) throws IOException {
        return AS400ImplRemote.parseMessages(this.data_, 24, converterImplRemote);
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving generate authentication token reply...");
        }
        if (this.readFromStream(inputStream, byArray = new byte[20], 0, 20) < 20) {
            Trace.log(2, "Failed to read all of the generate authentication token reply header.");
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 20);
        this.readAfterHeader(inputStream);
    }

    @Override
    public int hashCode() {
        return 61447;
    }
}

