/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import javax.transaction.xa.Xid;

public class AS400JDBCXid
implements Xid {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int formatId_ = -1;
    private byte[] globalTransactionId_ = null;
    private byte[] branchQualifier_ = null;

    AS400JDBCXid(byte[] byArray, int n) {
        this.formatId_ = BinaryConverter.byteArrayToInt(byArray, n);
        int n2 = BinaryConverter.byteArrayToInt(byArray, n + 4);
        int n3 = BinaryConverter.byteArrayToInt(byArray, n + 8);
        this.globalTransactionId_ = new byte[n2];
        System.arraycopy(byArray, n + 12, this.globalTransactionId_, 0, n2);
        this.branchQualifier_ = new byte[n3];
        System.arraycopy(byArray, n2 + n + 12, this.branchQualifier_, 0, n3);
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier_;
    }

    @Override
    public int getFormatId() {
        return this.formatId_;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId_;
    }

    byte[] toBytes() {
        return AS400JDBCXid.xidToBytes(this);
    }

    static byte[] xidToBytes(Xid xid) {
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        byte[] byArray3 = new byte[140];
        BinaryConverter.intToByteArray(n, byArray3, 0);
        BinaryConverter.intToByteArray(byArray.length, byArray3, 4);
        BinaryConverter.intToByteArray(byArray2.length, byArray3, 8);
        System.arraycopy(byArray, 0, byArray3, 12, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 12, byArray2.length);
        return byArray3;
    }
}

