/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Job;
import java.io.Serializable;

public class CallStackEntry
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 7L;
    private int requestLevel_;
    private String programName_;
    private String programLibrary_;
    private int miInstructionNumber_;
    private String moduleName_;
    private String moduleLibrary_;
    private byte controlBoundary_;
    private long activationGroupNumber_;
    private String activationGroupName_;
    private String programASP_;
    private String programLibraryASP_;
    private int programASPNumber_;
    private int programLibraryASPNumber_;
    private long activationGroupNumberLong_;
    private String[] statementIdentifiers_;
    private String procedureName_;
    private Job job_;
    private long threadID_;

    CallStackEntry(Job job, long l, int n, String string, String string2, int n2, String string3, String string4, byte by, long l2, String string5, String string6, String string7, int n3, int n4, long l3, String[] stringArray, String string8) {
        this.job_ = job;
        this.threadID_ = l;
        this.requestLevel_ = n;
        this.programName_ = string;
        this.programLibrary_ = string2;
        this.miInstructionNumber_ = n2;
        this.moduleName_ = string3;
        this.moduleLibrary_ = string4;
        this.controlBoundary_ = by;
        this.activationGroupNumber_ = l2;
        this.activationGroupName_ = string5;
        this.programASP_ = string6;
        this.programLibraryASP_ = string7;
        this.programASPNumber_ = n3;
        this.programLibraryASPNumber_ = n4;
        this.activationGroupNumberLong_ = l3;
        this.statementIdentifiers_ = stringArray;
        this.procedureName_ = string8;
    }

    public String getActivationGroupName() {
        return this.activationGroupName_;
    }

    public long getActivationGroupNumber() {
        if (this.activationGroupNumberLong_ != 0L) {
            return this.activationGroupNumberLong_;
        }
        return this.activationGroupNumber_;
    }

    public Job getJob() {
        return this.job_;
    }

    public int getMIInstructionNumber() {
        return this.miInstructionNumber_;
    }

    public String getModuleLibrary() {
        return this.moduleLibrary_;
    }

    public String getModuleName() {
        return this.moduleName_;
    }

    public String getProcedureName() {
        return this.procedureName_;
    }

    public String getProgramASPName() {
        return this.programASP_;
    }

    public int getProgramASPNumber() {
        return this.programASPNumber_;
    }

    public String getProgramLibrary() {
        return this.programLibrary_;
    }

    public String getProgramLibraryASPName() {
        return this.programLibraryASP_;
    }

    public int getProgramLibraryASPNumber() {
        return this.programLibraryASPNumber_;
    }

    public String getProgramName() {
        return this.programName_;
    }

    public int getRequestLevel() {
        return this.requestLevel_;
    }

    public String[] getStatementIdentifier() {
        if (this.statementIdentifiers_.length > 0) {
            String[] stringArray = new String[this.statementIdentifiers_.length];
            System.arraycopy(this.statementIdentifiers_, 0, stringArray, 0, this.statementIdentifiers_.length);
            return stringArray;
        }
        return this.statementIdentifiers_;
    }

    public long getThreadID() {
        return this.threadID_;
    }

    public boolean isControlBoundaryActive() {
        return this.controlBoundary_ == -15;
    }

    public String toString() {
        return super.toString() + "[" + this.job_.getSystem().getSystemName() + "/" + this.job_.getName() + "/" + this.job_.getUser() + "/" + this.job_.getNumber() + "/0x" + Long.toHexString(this.threadID_).toUpperCase() + "/" + this.requestLevel_ + "/" + (String)(this.procedureName_ == null ? this.programName_ + "/" + this.programLibrary_ : this.procedureName_) + "/" + Integer.toHexString(this.miInstructionNumber_).toUpperCase() + "]";
    }
}

