/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ClusteredHashTableEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ClusteredHashTable
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final int CONSISTENT_ENTRIES = 0;
    public static final int INCONSISTENT_ENTRIES = 1;
    public static final int ALL_ENTRIES = -1;
    static final int SIZE_OF_CHTS0100 = 36;
    static final int SIZE_OF_CHTI0100 = 24;
    static final int SIZE_OF_QUS_EC_T = 272;
    static final int SIZE_OF_KEY = 16;
    static final int MAX_DATA_SIZE = 62000;
    private transient boolean connected_ = false;
    private String name_;
    private transient byte[] connectionHandle_;
    private AS400 system_;
    private static final Object userSpaceLock_ = new Object();
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);

    public ClusteredHashTable() {
    }

    public ClusteredHashTable(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string.length() == 0 || string.length() > 10) {
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        this.system_ = aS400;
        this.name_ = string;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    private final void checkPropertiesSet() {
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
    }

    public synchronized void close() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (this.connected_) {
            try {
                ProgramParameter[] programParameterArray = new ProgramParameter[2];
                programParameterArray[0] = new ProgramParameter(this.connectionHandle_);
                programParameterArray[0].setParameterType(2);
                byte[] byArray = new byte[272];
                programParameterArray[1] = new ProgramParameter(byArray, 272);
                programParameterArray[1].setParameterType(2);
                ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_);
                serviceProgramCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", programParameterArray);
                serviceProgramCall.setProcedureName("QcstDisconnectCHT");
                serviceProgramCall.setReturnValueFormat(0);
                serviceProgramCall.suggestThreadsafe();
                if (!serviceProgramCall.run()) {
                    AS400Message[] aS400MessageArray = serviceProgramCall.getMessageList();
                    throw new AS400Exception(aS400MessageArray);
                }
                this.connectionHandle_ = null;
                this.connected_ = false;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public boolean containsKey(byte[] byArray) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (byArray == null) {
            throw new NullPointerException("key");
        }
        if (!this.connected_) {
            this.open();
        }
        try {
            this.get(byArray);
        }
        catch (AS400Exception aS400Exception) {
            AS400Message[] aS400MessageArray = aS400Exception.getAS400MessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                if (!aS400MessageArray[i].getID().startsWith("CPFBD06")) continue;
                return false;
            }
            throw new AS400Exception(aS400MessageArray);
        }
        return true;
    }

    public ClusteredHashTableEntry[] elements() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.elements(null, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredHashTableEntry[] elements(String string, String string2, int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        Object object;
        Object object2;
        ClusteredHashTableEntry[] clusteredHashTableEntryArray;
        UserSpace userSpace;
        ServiceProgramCall serviceProgramCall;
        Serializable serializable;
        block24: {
            if (string != null && string.length() > 10) {
                throw new ExtendedIllegalArgumentException("userProfile", 1);
            }
            if (string2 != null && string2.length() > 10) {
                throw new ExtendedIllegalArgumentException("lastModifiedProfile", 1);
            }
            if (n != 0 && n != 1 && n != -1) {
                throw new ExtendedIllegalArgumentException("status", 2);
            }
            if (string2 != null && string2.length() < 10) {
                serializable = new StringBuffer(string2);
                for (int i = string2.length(); i < 10; ++i) {
                    ((StringBuffer)serializable).append(" ");
                }
                string2 = ((StringBuffer)serializable).toString();
            }
            if (!this.connected_) {
                this.open();
            }
            if (string == null) {
                string = "*ALL      ";
            }
            if (string2 == null) {
                string2 = "*ALL      ";
            }
            serializable = new AS400Bin4();
            serviceProgramCall = new ServiceProgramCall(this.system_);
            String string3 = serviceProgramCall.getServerJob().getNumber();
            String string4 = "/QSYS.LIB/QUSRSYS.LIB/QCHT" + string3 + ".USRSPC";
            userSpace = new UserSpace(this.system_, string4);
            ProgramParameter[] programParameterArray = new ProgramParameter[7];
            try {
                clusteredHashTableEntryArray = new StringBuffer(20);
                clusteredHashTableEntryArray.append(userSpace.getName());
                for (int i = userSpace.getName().length(); i < 10; ++i) {
                    clusteredHashTableEntryArray.append(' ');
                }
                clusteredHashTableEntryArray.append("QUSRSYS");
                object2 = new AS400Text(20, this.system_.getCcsid(), this.system_);
                programParameterArray[0] = new ProgramParameter(((AS400Text)object2).toBytes(clusteredHashTableEntryArray.toString()));
                programParameterArray[0].setParameterType(2);
                object = new AS400Text(8, this.system_.getCcsid(), this.system_);
                programParameterArray[1] = new ProgramParameter(((AS400Text)object).toBytes("CHTL0100"));
                programParameterArray[1].setParameterType(2);
                programParameterArray[2] = new ProgramParameter(this.connectionHandle_);
                programParameterArray[2].setParameterType(2);
                AS400Text aS400Text = new AS400Text(10, this.system_.getCcsid(), this.system_);
                byte[] byArray = new byte[24];
                ((AS400Bin4)serializable).toBytes(n, byArray, 0);
                aS400Text.toBytes(string2, byArray, 4);
                aS400Text.toBytes(string, byArray, 14);
                programParameterArray[3] = new ProgramParameter(byArray);
                programParameterArray[3].setParameterType(2);
                programParameterArray[4] = new ProgramParameter(((AS400Bin4)serializable).toBytes(24));
                programParameterArray[4].setParameterType(2);
                programParameterArray[5] = new ProgramParameter(((AS400Text)object).toBytes("CHTI0100"));
                programParameterArray[5].setParameterType(2);
                byte[] byArray2 = new byte[272];
                programParameterArray[6] = new ProgramParameter(byArray2, 272);
                programParameterArray[6].setParameterType(2);
                serviceProgramCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", programParameterArray);
                serviceProgramCall.setProcedureName("QcstListCHTKeys");
                serviceProgramCall.setReturnValueFormat(0);
                serviceProgramCall.suggestThreadsafe();
            }
            catch (PropertyVetoException propertyVetoException) {
                if (!Trace.traceOn_) break block24;
                Trace.log(2, propertyVetoException);
            }
        }
        clusteredHashTableEntryArray = null;
        object2 = userSpaceLock_;
        synchronized (object2) {
            try {
                userSpace.create(1, true, " ", (byte)0, "CHT Wrapper Space", "*ALL");
                if (!serviceProgramCall.run()) {
                    object = serviceProgramCall.getMessageList();
                    throw new AS400Exception((AS400Message[])object);
                }
                object = new byte[4];
                userSpace.read((byte[])object, 124);
                int n2 = ((AS400Bin4)serializable).toInt((byte[])object);
                userSpace.read((byte[])object, 132);
                int n3 = ((AS400Bin4)serializable).toInt((byte[])object);
                userSpace.read((byte[])object, 136);
                int n4 = ((AS400Bin4)serializable).toInt((byte[])object);
                userSpace.read((byte[])object, 672);
                int n5 = ((AS400Bin4)serializable).toInt((byte[])object);
                Object var17_24 = null;
                clusteredHashTableEntryArray = new ClusteredHashTableEntry[n3];
                for (int i = 0; i < n3; ++i) {
                    byte[] byArray = new byte[16];
                    userSpace.read(byArray, n2 + n5 + n4 * i);
                    byte[] byArray3 = new byte[1];
                    clusteredHashTableEntryArray[i] = new ClusteredHashTableEntry(byArray, byArray3, 60, 0, 0);
                }
            }
            finally {
                try {
                    if (userSpace != null) {
                        userSpace.delete();
                    }
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                }
            }
        }
        return clusteredHashTableEntryArray;
    }

    public synchronized byte[] generateKey() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.connected_) {
            this.open();
        }
        AS400Bin4 aS400Bin4 = new AS400Bin4();
        byte[] byArray = new byte[16];
        try {
            ProgramParameter[] programParameterArray = new ProgramParameter[4];
            programParameterArray[0] = new ProgramParameter(byArray, 16);
            programParameterArray[0].setParameterType(2);
            programParameterArray[1] = new ProgramParameter(aS400Bin4.toBytes(16));
            programParameterArray[1].setParameterType(2);
            programParameterArray[2] = new ProgramParameter(this.connectionHandle_);
            programParameterArray[2].setParameterType(2);
            byte[] byArray2 = new byte[272];
            programParameterArray[3] = new ProgramParameter(byArray2, 272);
            programParameterArray[3].setParameterType(2);
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_);
            serviceProgramCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", programParameterArray);
            serviceProgramCall.setProcedureName("QcstGenerateCHTKey");
            serviceProgramCall.setReturnValueFormat(0);
            serviceProgramCall.suggestThreadsafe();
            if (!serviceProgramCall.run()) {
                AS400Message[] aS400MessageArray = serviceProgramCall.getMessageList();
                throw new AS400Exception(aS400MessageArray);
            }
            byArray = programParameterArray[0].getOutputData();
            if (Trace.isTraceOn()) {
                Trace.log(3, "Successfully generated key:", byArray);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return byArray;
    }

    public synchronized ClusteredHashTableEntry get(byte[] byArray) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (byArray == null) {
            throw new NullPointerException("key");
        }
        if (!this.connected_) {
            this.open();
        }
        AS400Bin4 aS400Bin4 = new AS400Bin4();
        byte[] byArray2 = new byte[62000];
        ProgramParameter[] programParameterArray = new ProgramParameter[7];
        ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.getSystem());
        ClusteredHashTableEntry clusteredHashTableEntry = null;
        try {
            programParameterArray[0] = new ProgramParameter(byArray2, 62000);
            programParameterArray[0].setParameterType(2);
            programParameterArray[1] = new ProgramParameter(aS400Bin4.toBytes(62000));
            programParameterArray[1].setParameterType(2);
            programParameterArray[2] = new ProgramParameter(this.connectionHandle_);
            programParameterArray[2].setParameterType(2);
            AS400Text aS400Text = new AS400Text(8, this.system_.getCcsid(), this.system_);
            programParameterArray[3] = new ProgramParameter(aS400Text.toBytes("CHTR0100"));
            programParameterArray[3].setParameterType(2);
            programParameterArray[4] = new ProgramParameter(aS400Bin4.toBytes(byArray.length));
            programParameterArray[4].setParameterType(2);
            programParameterArray[5] = new ProgramParameter(byArray);
            programParameterArray[5].setParameterType(2);
            byte[] byArray3 = new byte[272];
            programParameterArray[6] = new ProgramParameter(byArray3, 272);
            programParameterArray[6].setParameterType(2);
            serviceProgramCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", programParameterArray);
            serviceProgramCall.setProcedureName("QcstRetrieveCHTEntry");
            serviceProgramCall.setReturnValueFormat(0);
            serviceProgramCall.suggestThreadsafe();
            if (!serviceProgramCall.run()) {
                AS400Message[] aS400MessageArray = serviceProgramCall.getMessageList();
                throw new AS400Exception(aS400MessageArray);
            }
            byArray2 = programParameterArray[0].getOutputData();
            int n = aS400Bin4.toInt(byArray2, 12);
            int n2 = aS400Bin4.toInt(byArray2, 16);
            int n3 = aS400Bin4.toInt(byArray2, 20);
            byte[] byArray4 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray4[i] = byArray2[i + 44];
            }
            byte[] byArray5 = new byte[10];
            for (int i = 0; i < 10; ++i) {
                byArray5[i] = byArray2[i + 24];
            }
            byte[] byArray6 = new byte[10];
            for (int i = 0; i < 10; ++i) {
                byArray6[i] = byArray2[i + 34];
            }
            clusteredHashTableEntry = new ClusteredHashTableEntry(byArray, byArray4, 60, n3, 0);
            clusteredHashTableEntry.setOwnerProfile(new String(byArray5));
            clusteredHashTableEntry.setModifiedProfile(new String(byArray6));
            clusteredHashTableEntry.setEntryStatus(n2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return clusteredHashTableEntry;
    }

    public String getHandle() {
        if (this.connectionHandle_ == null) {
            return null;
        }
        return new String(this.connectionHandle_);
    }

    public String getName() {
        return this.name_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.connected_ = false;
        this.connectionHandle_ = null;
    }

    public boolean isEmpty() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.connected_) {
            this.open();
        }
        return this.size() == 0;
    }

    public synchronized void open() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.checkPropertiesSet();
        if (this.connected_) {
            return;
        }
        try {
            ProgramParameter[] programParameterArray = new ProgramParameter[3];
            programParameterArray[0] = new ProgramParameter(this.connectionHandle_, 16);
            programParameterArray[0].setParameterType(2);
            AS400Text aS400Text = new AS400Text(10, this.system_.getCcsid(), this.system_);
            programParameterArray[1] = new ProgramParameter(aS400Text.toBytes(this.name_));
            programParameterArray[1].setParameterType(2);
            byte[] byArray = new byte[272];
            programParameterArray[2] = new ProgramParameter(byArray, 272);
            programParameterArray[2].setParameterType(2);
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_);
            serviceProgramCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", programParameterArray);
            serviceProgramCall.setProcedureName("QcstConnectCHT");
            serviceProgramCall.setReturnValueFormat(0);
            serviceProgramCall.suggestThreadsafe();
            if (!serviceProgramCall.run()) {
                AS400Message[] aS400MessageArray = serviceProgramCall.getMessageList();
                throw new AS400Exception(aS400MessageArray);
            }
            this.connectionHandle_ = programParameterArray[0].getOutputData();
            this.connected_ = true;
            if (Trace.isTraceOn()) {
                Trace.log(3, "Connection handle is:", this.connectionHandle_);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public synchronized void put(ClusteredHashTableEntry clusteredHashTableEntry) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        int n;
        if (clusteredHashTableEntry == null) {
            throw new NullPointerException("entry");
        }
        this.checkPropertiesSet();
        if (clusteredHashTableEntry.getUpdateOption() != 0 && clusteredHashTableEntry.getUpdateOption() != 1) {
            throw new ExtendedIllegalArgumentException("entry", 2);
        }
        if (!this.connected_) {
            this.open();
        }
        AS400Bin4 aS400Bin4 = new AS400Bin4();
        byte[] byArray = new byte[36 + clusteredHashTableEntry.getKey().length + clusteredHashTableEntry.getUserData().length];
        int n2 = 0;
        byte[] byArray2 = aS400Bin4.toBytes(36);
        for (n = 0; n < 4; ++n) {
            byArray[n2++] = byArray2[n];
        }
        byArray2 = aS400Bin4.toBytes(clusteredHashTableEntry.getKey().length);
        for (n = 0; n < 4; ++n) {
            byArray[n2++] = byArray2[n];
        }
        byArray2 = aS400Bin4.toBytes(36 + clusteredHashTableEntry.getKey().length);
        for (n = 0; n < 4; ++n) {
            byArray[n2++] = byArray2[n];
        }
        byArray2 = aS400Bin4.toBytes(clusteredHashTableEntry.getUserData().length);
        for (n = 0; n < 4; ++n) {
            byArray[n2++] = byArray2[n];
        }
        for (n = 0; n < 8; ++n) {
            byArray[n2++] = 0;
        }
        byArray2 = aS400Bin4.toBytes(clusteredHashTableEntry.getUpdateOption());
        for (n = 0; n < 4; ++n) {
            byArray[n2++] = byArray2[n];
        }
        byArray2 = aS400Bin4.toBytes(clusteredHashTableEntry.getEntryAuthority());
        for (n = 0; n < 4; ++n) {
            byArray[n2++] = byArray2[n];
        }
        byArray2 = aS400Bin4.toBytes(clusteredHashTableEntry.getTimeToLive() / 60);
        for (n = 0; n < 4; ++n) {
            byArray[n2++] = byArray2[n];
        }
        byArray2 = clusteredHashTableEntry.getKey();
        for (n = 0; n < clusteredHashTableEntry.getKey().length; ++n) {
            byArray[n2++] = byArray2[n];
        }
        byArray2 = clusteredHashTableEntry.getUserData();
        for (n = 0; n < clusteredHashTableEntry.getUserData().length; ++n) {
            byArray[n2++] = byArray2[n];
        }
        try {
            ProgramParameter[] programParameterArray = new ProgramParameter[4];
            programParameterArray[0] = new ProgramParameter(this.connectionHandle_);
            programParameterArray[0].setParameterType(2);
            programParameterArray[1] = new ProgramParameter(byArray);
            programParameterArray[1].setParameterType(2);
            AS400Text aS400Text = new AS400Text(8, this.system_.getCcsid(), this.system_);
            programParameterArray[2] = new ProgramParameter(aS400Text.toBytes("CHTS0100"));
            programParameterArray[2].setParameterType(2);
            byte[] byArray3 = new byte[272];
            programParameterArray[3] = new ProgramParameter(byArray3, 272);
            programParameterArray[3].setParameterType(2);
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_);
            serviceProgramCall.setProgram("/QSYS.LIB/QCSTCHT.SRVPGM", programParameterArray);
            serviceProgramCall.setProcedureName("QcstStoreCHTEntry");
            serviceProgramCall.setReturnValueFormat(0);
            serviceProgramCall.suggestThreadsafe();
            if (!serviceProgramCall.run()) {
                AS400Message[] aS400MessageArray = serviceProgramCall.getMessageList();
                throw new AS400Exception(aS400MessageArray);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string.length() > 10) {
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        String string2 = this.name_;
        this.name_ = string;
        this.changes_.firePropertyChange("name", string2, this.name_);
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.system_;
        this.system_ = aS400;
        this.changes_.firePropertyChange("system", aS4002, this.system_);
    }

    public int size() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.connected_) {
            this.open();
        }
        ClusteredHashTableEntry[] clusteredHashTableEntryArray = this.elements();
        return clusteredHashTableEntryArray.length;
    }
}

