/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;

public abstract class ConvTableSingleMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    public char[] toUnicode_ = null;
    public byte[] fromUnicode_ = null;

    public ConvTableSingleMap(int n, char[] cArray, char[] cArray2) {
        super(n);
        this.ccsid_ = n;
        this.toUnicode_ = cArray;
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing single-byte conversion table for ccsid: " + this.ccsid_, cArray2.length);
        }
        this.fromUnicode_ = this.decompressSB(cArray2, (byte)63);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded single-byte map for ccsid: " + this.ccsid_);
        }
    }

    @Override
    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_ + " offset:" + n + " len:" + n2, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = this.toUnicode_[0xFF & byArray[n + n3++]];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray);
    }

    @Override
    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        char[] cArray = string.toCharArray();
        return this.stringToByteArray(cArray, 0, cArray.length);
    }

    @Override
    public final byte[] stringToByteArray(char[] cArray, int n, int n2) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray, n, n2));
        }
        byte[] byArray = new byte[n2];
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = this.fromUnicode_[cArray[n3++]];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray);
        }
        return byArray;
    }

    @Override
    public final void stringToByteArray(String string, byte[] byArray, int n) throws CharConversionException {
        char[] cArray = string.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        try {
            int n2 = 0;
            while (n2 < cArray.length) {
                byArray[n2 + n] = this.fromUnicode_[cArray[n2++]];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CharConversionException();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray, n, cArray.length);
        }
    }

    @Override
    public final void stringToByteArray(String string, byte[] byArray, int n, int n2) throws CharConversionException {
        char[] cArray = string.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        try {
            int n3 = 0;
            while (n3 < cArray.length && n3 < n2) {
                byArray[n3 + n] = this.fromUnicode_[cArray[n3++]];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CharConversionException();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray, n, cArray.length);
        }
    }

    public void updateToUnicode(int n, char c) {
        char[] cArray = this.toUnicode_;
        this.toUnicode_ = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            this.toUnicode_[i] = cArray[i];
        }
        this.toUnicode_[n] = c;
    }
}

